/*
** 3/06/2001
** http://graphics.stanford.edu/software/wiregl
**
** Copyright 2001
** The Board of Trustees of The Leland Stanford Junior University.
** All rights reserved.
**
** Except for commercial resale, lease, license or other commercial
** transactions, permission is hereby given to use, copy, and/or
** modify this software, provided that the above copyright notice and
** this permission notice appear in all copies of this software.  No
** part of this software or any derivatives thereof may be used in
** graphics systems for resale or for use in a commercial product.
**
** This software is provided "as is" and without warranty of any kind,
** express, implied or otherwise, including without limitation, any
** warranty of merchantability or fitness for a particular purpose.
*/

#ifdef WINDOWS
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#endif
#include <GL/gl.h>

#include "wiregl/include/wireGL.h"
#include "wiregl/include/wiregl_protocol.h"
#include "wiregl/include/wiregl_pipe.h"
#include "wiregl/include/wiregl_util.h"

/* HACK - this is defined in stream.c */
extern WireGLConnection *current_conn;

void 
__decodeReadPixels( void )
{
	GLint   x      = READ_DATA( 0, GLint );
	GLint   y      = READ_DATA( 4, GLint );
	GLsizei width  = READ_DATA( 8, GLsizei );
	GLsizei height = READ_DATA( 12, GLsizei );
	GLenum  format = READ_DATA( 16, GLenum );
	GLenum  type   = READ_DATA( 20, GLenum );

	GLint stride        = READ_DATA( 24, GLint  );
	GLint bytes_per_row = READ_DATA( 28, GLint );
	WireGLNetworkPointer *pixels = 
		(WireGLNetworkPointer *) ( unpacker_data_ptr + 32 );

	WireGLMessageReadPixels *msg;
	int len = sizeof(*msg) + height * bytes_per_row;
	msg = (WireGLMessageReadPixels *) wireGLAlloc( len );
	glReadPixels( x, y, width, height, format, type, msg + 1 );

	msg->type          = WIREGL_MESSAGE_READ_PIXELS;
	msg->bytes_per_row = bytes_per_row;
	msg->stride        = stride;
	msg->rows          = height;
	msg->pixels        = *pixels;
	
	INCR_DATA_PTR ( 32 + sizeof (*pixels) );

	wireGLNetSend( current_conn, NULL, msg, len );
}
