/*
** 3/06/2001
** http://graphics.stanford.edu/software/wiregl
**
** Copyright 2001
** The Board of Trustees of The Leland Stanford Junior University.
** All rights reserved.
**
** Except for commercial resale, lease, license or other commercial
** transactions, permission is hereby given to use, copy, and/or
** modify this software, provided that the above copyright notice and
** this permission notice appear in all copies of this software.  No
** part of this software or any derivatives thereof may be used in
** graphics systems for resale or for use in a commercial product.
**
** This software is provided "as is" and without warranty of any kind,
** express, implied or otherwise, including without limitation, any
** warranty of merchantability or fitness for a particular purpose.
*/

#ifdef WINDOWS
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#endif
#include <GL/gl.h>

#include "wiregl/include/wireGL.h"
#include "wiregl/include/wiregl_protocol.h"
#include "wiregl/include/wiregl_pipe.h"
#include "wiregl/include/wiregl_util.h"

void
__decodeDrawPixels( void )
{
	GLsizei width  = READ_DATA( sizeof( int ) + 0, GLsizei );
	GLsizei height = READ_DATA( sizeof( int ) + 4, GLsizei );
	GLenum format  = READ_DATA( sizeof( int ) + 8, GLenum );
	GLenum type    = READ_DATA( sizeof( int ) + 12, GLenum );
	GLvoid *pixels = DATA_POINTER( sizeof( int ) + 16, GLvoid );

	glPixelStorei( GL_UNPACK_ROW_LENGTH, 0 );
	glPixelStorei( GL_UNPACK_SKIP_PIXELS, 0 );
	glPixelStorei( GL_UNPACK_SKIP_ROWS, 0 );
	glPixelStorei( GL_UNPACK_ALIGNMENT, 1 );
	
	glDrawPixels( width, height, format, type, pixels );

	INCR_VAR_PTR( );
}

void
__decodeBitmap( void )
{	
	GLsizei width   = READ_DATA( sizeof( int ) + 0, GLsizei );
	GLsizei height  = READ_DATA( sizeof( int ) + 4, GLsizei );
	GLfloat xorig   = READ_DATA( sizeof( int ) + 8, GLfloat );
	GLfloat yorig   = READ_DATA( sizeof( int ) + 12, GLfloat );
	GLfloat xmove   = READ_DATA( sizeof( int ) + 16, GLfloat );
	GLfloat ymove   = READ_DATA( sizeof( int ) + 20, GLfloat );
	GLuint  is_null = READ_DATA( sizeof( int ) + 24, GLuint );
	GLubyte *bitmap = NULL;

	if ( !is_null )
	{
		bitmap = (GLubyte *) DATA_POINTER( sizeof(int) + 28, GLvoid );
	}

	glPixelStorei( GL_UNPACK_ROW_LENGTH, 0 );
	glPixelStorei( GL_UNPACK_SKIP_PIXELS, 0 );
	glPixelStorei( GL_UNPACK_SKIP_ROWS, 0 );
	glPixelStorei( GL_UNPACK_ALIGNMENT, 1 );
	__gltrack_Bitmap( width, height, xorig, yorig, xmove, ymove, bitmap );

	INCR_VAR_PTR( );
}
