/*
** 3/06/2001
** http://graphics.stanford.edu/software/wiregl
**
** Copyright 2001
** The Board of Trustees of The Leland Stanford Junior University.
** All rights reserved.
**
** Except for commercial resale, lease, license or other commercial
** transactions, permission is hereby given to use, copy, and/or
** modify this software, provided that the above copyright notice and
** this permission notice appear in all copies of this software.  No
** part of this software or any derivatives thereof may be used in
** graphics systems for resale or for use in a commercial product.
**
** This software is provided "as is" and without warranty of any kind,
** express, implied or otherwise, including without limitation, any
** warranty of merchantability or fitness for a particular purpose.
*/

#ifdef WINDOWS
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#endif
#include <GL/gl.h>

#include "wiregl/include/wireGL.h"
#include "wiregl/include/wiregl_pipe.h"
#include "wiregl/glcontext/glcontext.h"

/* HACK - these is defined in stream.c */
extern WireGLConnection *current_conn;
extern WireGLWorkQueue *__currentQueue;

void __decodeClear( void )
{
	WireGLWorkQueue *q = __currentQueue;
	int i;

	GLbitfield mask =  READ_DATA( 0, GLbitfield );
	INCR_DATA_PTR( 4 );

#if WIREGL_TRACK_DEPTH_COMPLEXITY
	/* we are in control of the stencil bit (we are using it to count
     * the number of times each pixel is touched), so don't let the
     * application clear it */
	mask &= ~GL_STENCIL_BUFFER_BIT;
	if ( mask == 0 )
	{
		return;
	}
#endif /* WIREGL_TRACK_DEPTH_COMPLEXITY */

	if ( q->apply_viewtransform )
	{
		/* MWE -- should this be here? */
		glEnable( GL_SCISSOR_TEST );

		for ( i = 0; i < q->num_extents; i++ ) 
		{
			WireGLWorkQueueExtent *extent = &q->extent[i];
			__glSetOutputBounds( q->context, &extent->outputwindow,
								 &q->imagespace, &extent->imagewindow );
			glClear( mask );
		}
	}
	else 
	{
		/* MWE -- should this be here? */
		glDisable( GL_SCISSOR_TEST );

		glClear( mask );
	}
}

