/*
** 3/06/2001
** http://graphics.stanford.edu/software/wiregl
**
** Copyright 2001
** The Board of Trustees of The Leland Stanford Junior University.
** All rights reserved.
**
** Except for commercial resale, lease, license or other commercial
** transactions, permission is hereby given to use, copy, and/or
** modify this software, provided that the above copyright notice and
** this permission notice appear in all copies of this software.  No
** part of this software or any derivatives thereof may be used in
** graphics systems for resale or for use in a commercial product.
**
** This software is provided "as is" and without warranty of any kind,
** express, implied or otherwise, including without limitation, any
** warranty of merchantability or fitness for a particular purpose.
*/

#ifdef WINDOWS
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#endif
#include <GL/gl.h>

#include "wiregl/include/wireGL.h"
#include "wiregl/include/wiregl_protocol.h"
#include "wiregl/include/wiregl_pipe.h"
#include "wiregl/include/wiregl_util.h"
#include "wiregl/glcontext/glcontext.h"

void __decodeVertexPointer( void ) {
	//GLint size = READ_DATA(0, GLint);
	//GLenum type = READ_DATA(4, GLenum);
	//GLcontext *context = __glGetCurrentContext();
	//__gltrack_VertexPointer (size, type, 0, context->client.v.cache);
	INCR_DATA_PTR( 8 );
}

void __decodeColorPointer( void ) {
	//GLint size = READ_DATA(0, GLint);
	//GLenum type = READ_DATA(4, GLenum);
	//GLcontext *context = __glGetCurrentContext();
	//__gltrack_ColorPointer (size, type, 0, context->client.c.cache);
	INCR_DATA_PTR( 8 );
}

void __decodeIndexPointer( void ) {
	//GLenum type = READ_DATA(0, GLenum);
	//GLcontext *context = __glGetCurrentContext();
	//__gltrack_IndexPointer (type, 0, context->client.i.cache);
	INCR_DATA_PTR( 4 );
}

void __decodeNormalPointer( void ) {
	//GLenum type = READ_DATA(0, GLenum);
	//GLcontext *context = __glGetCurrentContext();
	//__gltrack_NormalPointer (type, 0, context->client.n.cache);
	INCR_DATA_PTR( 4 );
}

void __decodeTexCoordPointer( void ) {
	//GLint size = READ_DATA(0, GLint);
	//GLenum type = READ_DATA(4, GLenum);
	//GLcontext *context = __glGetCurrentContext();
	//__gltrack_TexCoordPointer (size, type, 0, context->client.t.cache);
	INCR_DATA_PTR( 8 );
}

void __decodeEdgeFlagPointer( void ) {
	//GLcontext *context = __glGetCurrentContext();
	//__gltrack_EdgeFlagPointer (0, context->client.e.cache);
}

void __decodeEnableClientState( void )
{
	//GLenum array = READ_DATA( 0, GLenum );
	//__gltrack_EnableClientState (array);
	INCR_DATA_PTR( 4 );
}

void __decodeDisableClientState( void )
{
	//GLenum array = READ_DATA( 0, GLenum );
	//__gltrack_DisableClientState (array);
	INCR_DATA_PTR( 4 );
}

void __decodeDrawArrays ( void  ) {

	glDrawArrays(
		READ_DATA(0, GLenum), 
		READ_DATA(4, GLint),
		READ_DATA(8, GLsizei));
	INCR_DATA_PTR( 12 );
}

void __decodeArrayElement ( void  ) {
	glArrayElement( READ_DATA(0, GLint) );
	INCR_DATA_PTR( 4 );
}

void __decodeUpdateClientPointer ( void ) {
	int array = READ_DATA(4, int);
	int index_size = READ_DATA(8, int);
	int data_size = READ_DATA(12, int);
	int *index = DATA_POINTER(16, int);
	unsigned char *data = DATA_POINTER(16+index_size*sizeof(int), unsigned char);

	__glclient_UpdateClientPointer(array, index_size, index, data_size, data);

	INCR_VAR_PTR();
}


