##
## 3/06/2001
## http://graphics.stanford.edu/software/wiregl
##
## Copyright 2001
## The Board of Trustees of The Leland Stanford Junior University.
## All rights reserved.
##
## Except for commercial resale, lease, license or other commercial
## transactions, permission is hereby given to use, copy, and/or
## modify this software, provided that the above copyright notice and
## this permission notice appear in all copies of this software.  No
## part of this software or any derivatives thereof may be used in
## graphics systems for resale or for use in a commercial product.
##
## This software is provided "as is" and without warranty of any kind,
## express, implied or otherwise, including without limitation, any
## warranty of merchantability or fitness for a particular purpose.
##

import sys;
import cPickle;
import types;
import string;
import re;

import wiregl_common;

parsed_file = open( "gl_header.parsed", "rb" )
gl_mapping = cPickle.load( parsed_file )

keys = gl_mapping.keys()
keys.sort();

print """

/*
** 3/06/2001
** http://graphics.stanford.edu/software/wiregl
**
** Copyright 2001
** The Board of Trustees of The Leland Stanford Junior University.
** All rights reserved.
**
** Except for commercial resale, lease, license or other commercial
** transactions, permission is hereby given to use, copy, and/or
** modify this software, provided that the above copyright notice and
** this permission notice appear in all copies of this software.  No
** part of this software or any derivatives thereof may be used in
** graphics systems for resale or for use in a commercial product.
**
** This software is provided "as is" and without warranty of any kind,
** express, implied or otherwise, including without limitation, any
** warranty of merchantability or fitness for a particular purpose.
*/


#include <stdio.h>
#include <stdlib.h>
#include "wiregl/include/wireGL.h"
#include "wiregl/include/wiregl_protocol.h"
#include "wiregl/include/wiregl_util.h"

#define NAKED __declspec(naked)
"""

print "/* these pointers live in opengl_stub/api_templates.c */"
for func_name in keys:
    print "extern void *" + wiregl_common.DoImmediateMapping( func_name ) + ";"
print ""

for func_name in keys:
    ( return_type, arg_names, arg_types ) = gl_mapping[func_name]

    print "NAKED " + return_type + " gl" + func_name,
    print wiregl_common.ArgumentString( arg_names, arg_types )
    print "{"
    print "\t__asm jmp [" + wiregl_common.DoImmediateMapping( func_name ) + "]"
    for arg_name in arg_names:
        if arg_name: 
            print "\tWIREGL_UNUSED(" + arg_name + ");"
    print "}"
    print ""

