/*
** 3/06/2001
** http://graphics.stanford.edu/software/wiregl
**
** Copyright 2001
** The Board of Trustees of The Leland Stanford Junior University.
** All rights reserved.
**
** Except for commercial resale, lease, license or other commercial
** transactions, permission is hereby given to use, copy, and/or
** modify this software, provided that the above copyright notice and
** this permission notice appear in all copies of this software.  No
** part of this software or any derivatives thereof may be used in
** graphics systems for resale or for use in a commercial product.
**
** This software is provided "as is" and without warranty of any kind,
** express, implied or otherwise, including without limitation, any
** warranty of merchantability or fitness for a particular purpose.
*/

#include "wiregl/include/wireGL.h"
#include "wiregl/include/wiregl_client.h"
#include "wiregl/include/wiregl_protocol.h"

#ifdef WINDOWS
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#else
#include <X11/Xlib.h>
#endif

#include <stdio.h>

int WireGLGetWindowSize( int *width_return, int *height_return )
{
#ifdef WINDOWS
	RECT r;
	if (!__wiregl_globals.client_hwnd)
	{
		__wiregl_globals.client_hwnd = WindowFromDC( __wiregl_globals.client_hdc );
	}
	if (!__wiregl_globals.client_hwnd)
	{
		return 0;
	}
	GetClientRect( __wiregl_globals.client_hwnd, &r );
	*width_return = r.right - r.left;
	*height_return = r.bottom - r.top;

#else

	Window       root;
	int          x, y;
	unsigned int width, height, border, depth;

	if (!__wiregl_globals.glx_display)
	{
		return 0;
	}

	if ( !XGetGeometry( (Display *) __wiregl_globals.glx_display, 
						(Drawable) __wiregl_globals.glx_drawable,
						&root, &x, &y, &width, &height, &border, &depth ) )
		wireGLSimpleError( "XGetGeometry failed" );

	*width_return  = width;
	*height_return = height;
#endif
	return 1;
}

static void __handleWindowCoordsCall( GLint x, GLint y, GLsizei width, GLsizei height )
{
	unsigned char *data_ptr;
	GET_BUFFERED_POINTER( 16 );
	WRITE_DATA( 0, GLint, x );
	WRITE_DATA( 4, GLint, y );
	WRITE_DATA( 8, GLint, width );
	WRITE_DATA( 12, GLint, height );
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( Viewport  )(GLint x, GLint y, GLsizei width, GLsizei height )
{
	__handleWindowCoordsCall( x, y, width, height );
	WRITE_OPCODE( WIREGL_VIEWPORT_OPCODE );
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( Scissor  )( GLint x, GLint y, GLsizei width, GLsizei height )
{
	__handleWindowCoordsCall( x, y, width, height );
	WRITE_OPCODE( WIREGL_SCISSOR_OPCODE );
}
