/*
** 3/06/2001
** http://graphics.stanford.edu/software/wiregl
**
** Copyright 2001
** The Board of Trustees of The Leland Stanford Junior University.
** All rights reserved.
**
** Except for commercial resale, lease, license or other commercial
** transactions, permission is hereby given to use, copy, and/or
** modify this software, provided that the above copyright notice and
** this permission notice appear in all copies of this software.  No
** part of this software or any derivatives thereof may be used in
** graphics systems for resale or for use in a commercial product.
**
** This software is provided "as is" and without warranty of any kind,
** express, implied or otherwise, including without limitation, any
** warranty of merchantability or fitness for a particular purpose.
*/

#ifdef WINDOWS

#include "wiregl/include/wireGL.h"
#include "wiregl/include/wiregl_client.h"
#include "wiregl/include/wiregl_util.h"
#include "wiregl/glcontext/glcontext.h"

#include "geometry.h"

/* For information, see vertex_safecompressBB.c */

static __inline void __wiregl_handleVertexData( const GLfloat *x, const GLfloat *y, const GLfloat *z )
{
	unsigned char *data_ptr;
	unsigned int *data;
	unsigned int *clear;
	unsigned int outData[3];

	if(!__wiregl_compressiondatavalid)
		__wiregl_GuessCompressData(x, y, z);

	GET_BUFFERED_COUNT_POINTER( __wiregl_fastcompressdata.bytes );

	clear = data = (unsigned int *)data_ptr;

	__asm {
		mov ecx, __wiregl_fastcompressdata.bytes
		mov ebx, clear
		shr ecx, 2
clearLoop:
		mov dword ptr [ebx],0
		add ebx, 4
		dec ecx
		jne clearLoop
	}

	_asm {
		mov ebx, x
		mov esi, y
		mov edi, z
		fld [ebx]
		fld [esi]
		fld [edi]
		fld __wiregl_fastcompressdata.add[8]
		fadd
		fld __wiregl_fastcompressdata.mult[8]
		fmul
		fistp dword ptr outData[8]
		fld __wiregl_fastcompressdata.add[4]
		fadd
		fld __wiregl_fastcompressdata.mult[4]
		fmul
		fistp dword ptr outData[4]
		fld __wiregl_fastcompressdata.add[0]
		fadd
		fld __wiregl_fastcompressdata.mult[0]
		fmul
		fistp dword ptr outData[0]
	}

	*data = outData[0];
	*data |= outData[1] << __wiregl_fastcompressdata.shiftLeft[0];
	*data |= outData[2] << __wiregl_fastcompressdata.shiftLeft[1];
	if(__wiregl_fastcompressdata.bitsLeft)
		*(data + 1) = outData[2] >> __wiregl_fastcompressdata.bitsLeft;

	WRITE_OPCODE( WIREGL_VERTEX3COMPRESSED_OPCODE );
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexCompressC3d ) ( GLdouble x, GLdouble y, GLdouble z )
{
	GLfloat fx = (GLfloat)x, fy = (GLfloat)y, fz = (GLfloat)z;
	__wiregl_handleVertexData(&fx, &fy, &fz);
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexCompressC3dv ) ( const GLdouble *v )
{
	GLfloat fx = (GLfloat)v[0], fy = (GLfloat)v[1], fz = (GLfloat)v[2];
	__wiregl_handleVertexData(&fx, &fy, &fz);
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexCompressC3f ) ( GLfloat x, GLfloat y, GLfloat z )
{
	__wiregl_handleVertexData(&x, &y, &z);
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexCompressC3fv ) ( const GLfloat *v )
{
	__wiregl_handleVertexData(&v[0], &v[1], &v[2]);
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexCompressC3i ) ( GLint x, GLint y, GLint z )
{
	GLfloat fx = (GLfloat)x, fy = (GLfloat)y, fz = (GLfloat)z;
	__wiregl_handleVertexData(&fx, &fy, &fz);
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexCompressC3iv ) ( const GLint *v )
{
	GLfloat fx = (GLfloat)v[0], fy = (GLfloat)v[1], fz = (GLfloat)v[2];
	__wiregl_handleVertexData(&fx, &fy, &fz);
}

GLapi vertexCompressCapi[] = {
	{"glVertex2d",  (GLfunc) WIREGL_PACK_FUNCTION( VertexC2d )},
	{"glVertex2dv", (GLfunc) WIREGL_PACK_FUNCTION( VertexC2dv )},
	{"glVertex2f",  (GLfunc) WIREGL_PACK_FUNCTION( VertexC2f )},
	{"glVertex2fv", (GLfunc) WIREGL_PACK_FUNCTION( VertexC2fv )},
	{"glVertex2i",  (GLfunc) WIREGL_PACK_FUNCTION( VertexC2i )},
	{"glVertex2iv", (GLfunc) WIREGL_PACK_FUNCTION( VertexC2iv )},
	{"glVertex2s",  (GLfunc) WIREGL_PACK_FUNCTION( VertexC2s )},
	{"glVertex2sv", (GLfunc) WIREGL_PACK_FUNCTION( VertexC2sv )},
	{"glVertex3d",  (GLfunc) WIREGL_PACK_FUNCTION( VertexCompressC3d )},
	{"glVertex3dv", (GLfunc) WIREGL_PACK_FUNCTION( VertexCompressC3dv )},
	{"glVertex3f",  (GLfunc) WIREGL_PACK_FUNCTION( VertexCompressC3f )},
	{"glVertex3fv", (GLfunc) WIREGL_PACK_FUNCTION( VertexCompressC3fv )},
	{"glVertex3i",  (GLfunc) WIREGL_PACK_FUNCTION( VertexCompressC3i )},
	{"glVertex3iv", (GLfunc) WIREGL_PACK_FUNCTION( VertexCompressC3iv )},
	{"glVertex3s",  (GLfunc) WIREGL_PACK_FUNCTION( VertexC3s )},
	{"glVertex3sv", (GLfunc) WIREGL_PACK_FUNCTION( VertexC3sv )},
	{"glVertex4d",  (GLfunc) WIREGL_PACK_FUNCTION( VertexC4d )},
	{"glVertex4dv", (GLfunc) WIREGL_PACK_FUNCTION( VertexC4dv )},
	{"glVertex4f",  (GLfunc) WIREGL_PACK_FUNCTION( VertexC4f )},
	{"glVertex4fv", (GLfunc) WIREGL_PACK_FUNCTION( VertexC4fv )},
	{"glVertex4i",  (GLfunc) WIREGL_PACK_FUNCTION( VertexC4i )},
	{"glVertex4iv", (GLfunc) WIREGL_PACK_FUNCTION( VertexC4iv )},
	{"glVertex4s",  (GLfunc) WIREGL_PACK_FUNCTION( VertexC4s )},
	{"glVertex4sv", (GLfunc) WIREGL_PACK_FUNCTION( VertexC4sv )},
	{NULL, NULL}};

#endif
