/*
** 3/06/2001
** http://graphics.stanford.edu/software/wiregl
**
** Copyright 2001
** The Board of Trustees of The Leland Stanford Junior University.
** All rights reserved.
**
** Except for commercial resale, lease, license or other commercial
** transactions, permission is hereby given to use, copy, and/or
** modify this software, provided that the above copyright notice and
** this permission notice appear in all copies of this software.  No
** part of this software or any derivatives thereof may be used in
** graphics systems for resale or for use in a commercial product.
**
** This software is provided "as is" and without warranty of any kind,
** express, implied or otherwise, including without limitation, any
** warranty of merchantability or fitness for a particular purpose.
*/

#include "wiregl/include/wireGL.h"
#include "wiregl/include/wiregl_util.h"
#include "packer_internals.h"

GLint __gl_TypeSize( GLenum type )
{
    GLint size = 0;

    switch ( type ) 
		{
      case GL_UNSIGNED_BYTE:
      case GL_BYTE:
        size = 1;
        break;
      case GL_UNSIGNED_SHORT:
      case GL_SHORT:
        size = 2;
        break;
      case GL_UNSIGNED_INT:
      case GL_INT:
      case GL_FLOAT:
        size = 4;
        break;
			default:
				wireGLSimpleError( "Unknown type: %d", type );
    }

    return size;
}
