/*
** 3/06/2001
** http://graphics.stanford.edu/software/wiregl
**
** Copyright 2001
** The Board of Trustees of The Leland Stanford Junior University.
** All rights reserved.
**
** Except for commercial resale, lease, license or other commercial
** transactions, permission is hereby given to use, copy, and/or
** modify this software, provided that the above copyright notice and
** this permission notice appear in all copies of this software.  No
** part of this software or any derivatives thereof may be used in
** graphics systems for resale or for use in a commercial product.
**
** This software is provided "as is" and without warranty of any kind,
** express, implied or otherwise, including without limitation, any
** warranty of merchantability or fitness for a particular purpose.
*/

#include "wiregl/include/wireGL.h"
#include "wiregl/include/wiregl_util.h"
#include "wiregl/include/wiregl_protocol.h"
#include "wiregl/glcontext/glcontext.h"

GLboolean OPENGL_APIENTRY WIREGL_PACK_FUNCTION( AreTexturesResident  )( GLsizei n, const GLuint *textures, GLboolean *residences )
{
	WIREGL_UNUSED(n);
	WIREGL_UNUSED(textures);
	WIREGL_UNUSED(residences);
	wireGLError( "glAreTexturesResident needs to be special cased" );
	return 0;
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( GetBooleanv  )( GLenum pname, GLboolean * params ) 
{
	__glstate_GetBooleanv( pname, params );
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( GetClipPlane  )( GLenum plane, GLdouble *equation )
{
	WIREGL_UNUSED(plane);
	WIREGL_UNUSED(equation);
	wireGLError( "glGetClipPlane needs to be special cased" );
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( GetDoublev  )( GLenum pname, GLdouble *params )
{
	__glstate_GetDoublev( pname, params );
}

GLenum OPENGL_APIENTRY WIREGL_PACK_FUNCTION( GetError  )()
{
	return __glstate_GetError();
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( GetFloatv  )( GLenum pname, GLfloat *params )
{
	__glstate_GetFloatv( pname, params );
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( GetIntegerv  )( GLenum pname, GLint *params )
{
	__glstate_GetIntegerv( pname, params );
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( GetLightfv  )( GLenum light, GLenum pname, GLfloat *params )
{
	WIREGL_UNUSED(light);
	WIREGL_UNUSED(pname);
	WIREGL_UNUSED(params);
	wireGLError( "glGetLightfv needs to be special cased" );
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( GetLightiv  )( GLenum light, GLenum pname, GLint *params )
{
	WIREGL_UNUSED(light);
	WIREGL_UNUSED(pname);
	WIREGL_UNUSED(params);
	wireGLError( "glGetLightiv needs to be special cased" );
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( GetMapdv  )( GLenum target, GLenum query, GLdouble *v )
{
	WIREGL_UNUSED(target);
	WIREGL_UNUSED(query);
	WIREGL_UNUSED(v);
	wireGLError( "glGetMapdv needs to be special cased" );
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( GetMapfv  )( GLenum target, GLenum query, GLfloat *v )
{
	WIREGL_UNUSED(target);
	WIREGL_UNUSED(query);
	WIREGL_UNUSED(v);
	wireGLError( "glGetMapfv needs to be special cased" );
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( GetMapiv  )( GLenum target, GLenum query, GLint *v )
{
	WIREGL_UNUSED(target);
	WIREGL_UNUSED(query);
	WIREGL_UNUSED(v);
	wireGLError( "glGetMapiv needs to be special cased" );
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( GetMaterialfv  )( GLenum face, GLenum pname, GLfloat *params )
{
	WIREGL_UNUSED(face);
	WIREGL_UNUSED(pname);
	WIREGL_UNUSED(params);
	wireGLError( "glGetMaterialfv needs to be special cased" );
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( GetMaterialiv  )( GLenum face, GLenum pname, GLint *params )
{
	WIREGL_UNUSED(face);
	WIREGL_UNUSED(pname);
	WIREGL_UNUSED(params);
	wireGLError( "glGetMaterialiv needs to be special cased" );
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( GetPixelMapfv  )( GLenum map, GLfloat *values )
{
	WIREGL_UNUSED(map);
	WIREGL_UNUSED(values);
	wireGLError( "glGetPixelMapfv needs to be special cased" );
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( GetPixelMapuiv  )( GLenum map, GLuint *values )
{
	WIREGL_UNUSED(map);
	WIREGL_UNUSED(values);
	wireGLError( "glGetPixelMapuiv needs to be special cased" );
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( GetPixelMapusv  )( GLenum map, GLushort *values )
{
	WIREGL_UNUSED(map);
	WIREGL_UNUSED(values);
	wireGLError( "glGetpixelMapusv needs to be special cased" );
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( GetPointerv  )( GLenum pname, GLvoid **params )
{
	WIREGL_UNUSED(pname);
	WIREGL_UNUSED(params);
	wireGLError( "glGetPointerv needs to be special cased" );
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( GetPolygonStipple  )( GLubyte *mask )
{
	WIREGL_UNUSED(mask);
	wireGLError( "glGetPolygonStipple needs to be special cased" );
}

const GLubyte * OPENGL_APIENTRY WIREGL_PACK_FUNCTION( GetString  )( GLenum name )
{
	WIREGL_UNUSED(name);
	return (const GLubyte *) "Not quite yet";
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( GetTexEnvfv  )( GLenum target, GLenum pname, GLfloat *params )
{
	WIREGL_UNUSED(target);
	WIREGL_UNUSED(pname);
	WIREGL_UNUSED(params);
	wireGLError( "glGetTexEnvfv needs to be special cased" );
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( GetTexEnviv  )( GLenum target, GLenum pname, GLint *params )
{
	WIREGL_UNUSED(target);
	WIREGL_UNUSED(pname);
	WIREGL_UNUSED(params);
	wireGLError( "glGetTexEnviv needs to be special cased" );
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( GetTexGendv  )( GLenum coord, GLenum pname, GLdouble *params )
{
	WIREGL_UNUSED(coord);
	WIREGL_UNUSED(pname);
	WIREGL_UNUSED(params);
	wireGLError( "glGetTexGendv needs to be special cased" );
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( GetTexGenfv  )( GLenum coord, GLenum pname, GLfloat *params )
{
	WIREGL_UNUSED(coord);
	WIREGL_UNUSED(pname);
	WIREGL_UNUSED(params);
	wireGLError( "glGetTexGenfv needs to be special cased" );
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( GetTexGeniv  )( GLenum coord, GLenum pname, GLint *params )
{
	WIREGL_UNUSED(coord);
	WIREGL_UNUSED(pname);
	WIREGL_UNUSED(params);
	wireGLError( "glGetTexGeniv needs to be special cased" );
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( GetTexImage  )( GLenum target, GLint level, GLenum format, GLenum type, GLvoid *pixels )
{
	WIREGL_UNUSED(target);
	WIREGL_UNUSED(level);
	WIREGL_UNUSED(format);
	WIREGL_UNUSED(type);
	WIREGL_UNUSED(pixels);
	wireGLError( "glGetTexImage needs to be special cased" );
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( GetTexLevelParameterfv  )( GLenum target, GLint level, GLenum pname, GLfloat *params )
{
	WIREGL_UNUSED(target);
	WIREGL_UNUSED(level);
	WIREGL_UNUSED(pname);
	WIREGL_UNUSED(params);
	wireGLError( "glGetTexLevelParameterfv needs to be special cased" );
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( GetTexLevelParameteriv  )( GLenum target, GLint level, GLenum pname, GLint *params )
{
	WIREGL_UNUSED(target);
	WIREGL_UNUSED(level);
	WIREGL_UNUSED(pname);
	WIREGL_UNUSED(params);
	wireGLError( "glGetTexLevelParameteriv needs to be special cased" );
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( GetTexParameterfv  )( GLenum target, GLenum pname, GLfloat *params )
{
	WIREGL_UNUSED(target);
	WIREGL_UNUSED(pname);
	WIREGL_UNUSED(params);
	wireGLError( "glGetTexParemeterfv needs to be special cased" );
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( GetTexParameteriv  )( GLenum target, GLenum pname, GLint *params )
{
	WIREGL_UNUSED(target);
	WIREGL_UNUSED(pname);
	WIREGL_UNUSED(params);
	wireGLError( "glGetTexParemeteriv needs to be special cased" );
}

GLboolean OPENGL_APIENTRY WIREGL_PACK_FUNCTION( IsEnabled   )(GLenum cap)
{
	return __glstate_IsEnabled( cap );
}

GLboolean OPENGL_APIENTRY WIREGL_PACK_FUNCTION( IsList   )(GLuint list)
{
	return __glstate_IsList( list );
}

GLboolean OPENGL_APIENTRY WIREGL_PACK_FUNCTION( IsTexture   )(GLuint texture )
{
	WIREGL_UNUSED(texture);
	wireGLError( "glIsTexture needs to be special cased" );
	return 0;
}
