/*
** 3/06/2001
** http://graphics.stanford.edu/software/wiregl
**
** Copyright 2001
** The Board of Trustees of The Leland Stanford Junior University.
** All rights reserved.
**
** Except for commercial resale, lease, license or other commercial
** transactions, permission is hereby given to use, copy, and/or
** modify this software, provided that the above copyright notice and
** this permission notice appear in all copies of this software.  No
** part of this software or any derivatives thereof may be used in
** graphics systems for resale or for use in a commercial product.
**
** This software is provided "as is" and without warranty of any kind,
** express, implied or otherwise, including without limitation, any
** warranty of merchantability or fitness for a particular purpose.
*/

#include "wiregl/include/wireGL.h"
#include "wiregl/include/wiregl_util.h"
#include "packer_internals.h"


GLint __gl_ComputePixelPointer2D( GLint width,
		GLcontext *ctx, GLenum format, GLenum type, GLint *rowSizeRet )
{
	GLint offset, pixelSize, rowSize;

	if (ctx->pixel.unpackrowlength > 0)
		width = ctx->pixel.unpackrowlength;

	pixelSize = __gl_PixelSizeInBytes( format, type );

	rowSize = pixelSize * width;
	if ( __gl_TypeSize( type ) < ctx->pixel.unpackalignment )
	{
		GLuint i = ctx->pixel.unpackalignment -1;
		rowSize = ( rowSize + i ) & ~i;
	}

	offset = 0;

	if ( ctx->pixel.unpackskiprows > 0 )
		offset += rowSize * ctx->pixel.unpackskiprows;
	if ( ctx->pixel.unpackskippixels > 0 )
		offset += pixelSize * ctx->pixel.unpackskippixels;

	*rowSizeRet = rowSize;
	return offset;
}

GLint __gl_PixelSizeInBytes( GLenum format, GLenum type )
{
    GLint components = 0;

    switch ( format ) 
		{
      case GL_COLOR_INDEX:
			case GL_STENCIL_INDEX:
			case GL_DEPTH_COMPONENT:
      case GL_RED:
      case GL_GREEN:
      case GL_BLUE:
      case GL_ALPHA:
      case GL_LUMINANCE:
        components = 1;
        break;
      case GL_LUMINANCE_ALPHA:
        components = 2;
        break;
      case GL_RGB:
        components = 3;
        break;
      case GL_RGBA:
        components = 4;
        break;
			default:
				wireGLSimpleError( "Unknown format: %d", format );
    }

    return components * __gl_TypeSize( type );
}
