##
## 3/06/2001
## http://graphics.stanford.edu/software/wiregl
##
## Copyright 2001
## The Board of Trustees of The Leland Stanford Junior University.
## All rights reserved.
##
## Except for commercial resale, lease, license or other commercial
## transactions, permission is hereby given to use, copy, and/or
## modify this software, provided that the above copyright notice and
## this permission notice appear in all copies of this software.  No
## part of this software or any derivatives thereof may be used in
## graphics systems for resale or for use in a commercial product.
##
## This software is provided "as is" and without warranty of any kind,
## express, implied or otherwise, including without limitation, any
## warranty of merchantability or fitness for a particular purpose.
##

import sys;
import cPickle;
import string;
import re;

import wiregl_common;

parsed_file = open( "gl_header.parsed", "rb" )
gl_mapping = cPickle.load( parsed_file )

print ""
print "#ifndef WIREGL_OPCODES_H"
print "#define WIREGL_OPCODES_H"
print ""

keys = gl_mapping.keys()
keys.sort();

print "typedef enum {"

enum_index = 0
for index in range(0,len(keys)):
    func_name = keys[index]
    if not wiregl_common.FindSpecial( "internal_header", func_name ):
	print "\t" + wiregl_common.OpcodeName( func_name ) + " = " + `enum_index` + ","
	enum_index = enum_index + 1

for func_name in ( "SwapBuffers", "CreateContext", "UpdateClientPointer", "Normal3Compressed", "Vertex3Compressed", "SetVertexCompressionData", "Writeback", "BoundsInfo", "NOP" ):
    print "\t" + wiregl_common.OpcodeName( func_name ) + " = " + `enum_index`,
    if func_name != "NOP":
	print ","
    enum_index = enum_index + 1

print ""
print "} WireGLOpcode;"
print ""
print "#endif /* WIREGL_OPCODES_H */"
