/*
** 3/06/2001
** http://graphics.stanford.edu/software/wiregl
**
** Copyright 2001
** The Board of Trustees of The Leland Stanford Junior University.
** All rights reserved.
**
** Except for commercial resale, lease, license or other commercial
** transactions, permission is hereby given to use, copy, and/or
** modify this software, provided that the above copyright notice and
** this permission notice appear in all copies of this software.  No
** part of this software or any derivatives thereof may be used in
** graphics systems for resale or for use in a commercial product.
**
** This software is provided "as is" and without warranty of any kind,
** express, implied or otherwise, including without limitation, any
** warranty of merchantability or fitness for a particular purpose.
*/

#include "wiregl/include/wireGL.h"
#include "wiregl/include/wiregl_protocol.h"
#include "wiregl/include/wiregl_client.h"
#include "wiregl/glcontext/glcontext.h"
#include "wiregl/include/wiregl_util.h"

static int __gl_CallListsNumBytes( GLenum type )
{
	switch( type )
	{
		case GL_BYTE:
		case GL_UNSIGNED_BYTE:
		case GL_2_BYTES:
			return 1;
		case GL_SHORT:
		case GL_UNSIGNED_SHORT:
		case GL_3_BYTES:
			return 2;
		case GL_INT:
		case GL_UNSIGNED_INT:
		case GL_FLOAT:
		case GL_4_BYTES:
			return 4;
		default:
			wireGLError( "Invalid type: %d", type );
	}
	return -1;
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( CallLists ) (GLint n, GLenum type, 
		const GLvoid *lists )
{
	unsigned char *data_ptr;
	int packet_length;

	int num_bytes = __gl_CallListsNumBytes( type ) * n;

	packet_length = 
		sizeof( n ) + 
		sizeof( type ) + 
		num_bytes;

	data_ptr = (unsigned char *) wireGLAllocPacket( packet_length );
	WRITE_DATA( 0, GLint, n );
	WRITE_DATA( 4, GLenum, type );
	memcpy( data_ptr + 8, lists, num_bytes );

	wireGLSendPacket( WIREGL_CALLLISTS_OPCODE, data_ptr );
	wireGLFreePacket( data_ptr );
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( DeleteLists  )(GLuint list, GLsizei range)
{
	WIREGL_UNUSED(list);
	WIREGL_UNUSED(range);
}

GLuint OPENGL_APIENTRY WIREGL_PACK_FUNCTION( GenLists  )(GLsizei range)
{
	/* SHOULD NOT BE CALLED !!!*/
	return __glstate_GenLists(range);
}
