/*
** 3/06/2001
** http://graphics.stanford.edu/software/wiregl
**
** Copyright 2001
** The Board of Trustees of The Leland Stanford Junior University.
** All rights reserved.
**
** Except for commercial resale, lease, license or other commercial
** transactions, permission is hereby given to use, copy, and/or
** modify this software, provided that the above copyright notice and
** this permission notice appear in all copies of this software.  No
** part of this software or any derivatives thereof may be used in
** graphics systems for resale or for use in a commercial product.
**
** This software is provided "as is" and without warranty of any kind,
** express, implied or otherwise, including without limitation, any
** warranty of merchantability or fitness for a particular purpose.
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "wiregl/include/wireGL.h"
#include "wiregl/include/wiregl_protocol.h"
#include "wiregl/include/wiregl_client.h"
#include "wiregl/include/wiregl_util.h"
#include "wiregl/glcontext/glcontext.h"
#include "packer_internals.h"

void OPENGL_APIENTRY 
WIREGL_PACK_FUNCTION( DrawPixels )( GLsizei width, GLsizei height,
								    GLenum format, GLenum type,
									const GLvoid *pixels )
{
	GLcontext *ctx = __wiregl_globals.context;
	unsigned char *data_ptr;
	int packet_length;
	int datasize;

	if ( pixels == NULL )
	{
		return;
	}

	if (type == GL_BITMAP)
	{
		WIREGL_PACK_FUNCTION( Bitmap  )( width, height, 0, 0, 0, 0, 
										 (const GLubyte *) pixels );
		return;
	}

	packet_length = 
		sizeof( width ) + 
		sizeof( height ) +
		sizeof( format ) +
		sizeof( type );

	datasize = __glpixel_getdata2Dsize(width, height, format, type );
	packet_length += datasize;

	data_ptr = (unsigned char *) wireGLAllocPacket( packet_length );
	WRITE_DATA( 0, GLsizei, width );
	WRITE_DATA( 4, GLsizei, height );
	WRITE_DATA( 8, GLenum, format );
	WRITE_DATA( 12, GLenum, type );

	__glpixel_getdata2D( (GLvoid *)(data_ptr + 16),
						 width, height, format, type, pixels );

	wireGLMultiSendPacket( ctx, WIREGL_DRAWPIXELS_OPCODE, data_ptr );

	wireGLFreePacket( data_ptr );
}

void OPENGL_APIENTRY 
WIREGL_PACK_FUNCTION( Bitmap )( GLsizei width, GLsizei height,
								GLfloat xorig, GLfloat yorig,
								GLfloat xmove, GLfloat ymove,
								const GLubyte *bitmap )
{
	GLcontext *ctx = __wiregl_globals.context;
	unsigned char *data_ptr;
	int row_length, data_length=0;
	int packet_length = 
		sizeof( width ) + 
		sizeof( height ) +
		sizeof( xorig ) + 
		sizeof( yorig ) + 
		sizeof( xmove ) + 
		sizeof( ymove ) +
		sizeof( GLuint );

	if ( bitmap )
	{
		if ( ctx->pixel.unpackrowlength  != 0 ||
			 ctx->pixel.unpackalignment  != 1 ||
			 ctx->pixel.unpackskiprows   != 0 ||
			 ctx->pixel.unpackskippixels != 0 )
		{
			wireGLSimpleError( "glBitmap( ) : I don't know how to unpack "
							   "the current pixelstore" );
		}

		row_length = ( ( width + 7 ) & ~7 ) >> 3;
		data_length = row_length * height;
		packet_length += data_length;
	}

	data_ptr = (unsigned char *) wireGLAllocPacket( packet_length );
	WRITE_DATA( 0, GLsizei, width );
	WRITE_DATA( 4, GLsizei, height );
	WRITE_DATA( 8, GLfloat, xorig );
	WRITE_DATA( 12, GLfloat, yorig );
	WRITE_DATA( 16, GLfloat, xmove );
	WRITE_DATA( 20, GLfloat, ymove );
	WRITE_DATA( 24, GLuint, ( bitmap == NULL ) );
	if ( bitmap )
	{
		memcpy( data_ptr + 28, bitmap, data_length );
	}

	wireGLMultiSendPacket( ctx, WIREGL_BITMAP_OPCODE, data_ptr );

	wireGLFreePacket( data_ptr );
}
