/*
** 3/06/2001
** http://graphics.stanford.edu/software/wiregl
**
** Copyright 2001
** The Board of Trustees of The Leland Stanford Junior University.
** All rights reserved.
**
** Except for commercial resale, lease, license or other commercial
** transactions, permission is hereby given to use, copy, and/or
** modify this software, provided that the above copyright notice and
** this permission notice appear in all copies of this software.  No
** part of this software or any derivatives thereof may be used in
** graphics systems for resale or for use in a commercial product.
**
** This software is provided "as is" and without warranty of any kind,
** express, implied or otherwise, including without limitation, any
** warranty of merchantability or fitness for a particular purpose.
*/

#include "wiregl/include/wireGL.h"
#include "wiregl/include/wiregl_protocol.h"
#include "wiregl/include/wiregl_client.h"

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( ClipPlane  )( GLenum plane, const GLdouble *equation )
{
	unsigned char *data_ptr;
	int packet_length = sizeof( plane ) + 4*sizeof(*equation);
	GET_BUFFERED_POINTER( packet_length );
	WRITE_DATA( 0, GLenum, plane );
	WRITE_DOUBLE( 4, equation[0] );
	WRITE_DOUBLE( 12, equation[1] );
	WRITE_DOUBLE( 20, equation[2] );
	WRITE_DOUBLE( 28, equation[3] );
	WRITE_OPCODE( WIREGL_CLIPPLANE_OPCODE );
}
