/*
** 3/06/2001
** http://graphics.stanford.edu/software/wiregl
**
** Copyright 2001
** The Board of Trustees of The Leland Stanford Junior University.
** All rights reserved.
**
** Except for commercial resale, lease, license or other commercial
** transactions, permission is hereby given to use, copy, and/or
** modify this software, provided that the above copyright notice and
** this permission notice appear in all copies of this software.  No
** part of this software or any derivatives thereof may be used in
** graphics systems for resale or for use in a commercial product.
**
** This software is provided "as is" and without warranty of any kind,
** express, implied or otherwise, including without limitation, any
** warranty of merchantability or fitness for a particular purpose.
*/

#include "wiregl/include/wireGL.h"
#include "wiregl/include/wiregl_protocol.h"
#include "wiregl/include/wiregl_client.h"
#include "wiregl/include/wiregl_util.h"

void __glpack_UpdateClientPointer (int array, int index_size, int *index, int data_size, unsigned char * data) {
	unsigned char *data_ptr;
	int packet_length;
	packet_length = 
		sizeof( array ) + 
		sizeof( index_size ) + 
		sizeof( data_size) + 
		index_size*sizeof(int) + 
		data_size;

	data_ptr = (unsigned char *) wireGLAllocPacket( packet_length );

	WRITE_DATA( 0, int, array );
	WRITE_DATA( 4, int, index_size );
	WRITE_DATA( 8, int, data_size );
	memcpy( data_ptr + 12, index, index_size*sizeof(int));
	memcpy( data_ptr + 12 + index_size*sizeof(int), data, data_size);

	wireGLSendPacket( WIREGL_UPDATECLIENTPOINTER_OPCODE, data_ptr );
	wireGLFreePacket( data_ptr );
}

void OPENGL_APIENTRY
WIREGL_PACK_FUNCTION( VertexPointer  )(GLint size, GLenum type, GLsizei stride, const GLvoid *p) {
	unsigned char *data_ptr;
	GET_BUFFERED_POINTER ( 8);
	WRITE_DATA( 0, GLint, size);
	WRITE_DATA( 4, GLenum, type);
	WIREGL_UNUSED(stride);
	WIREGL_UNUSED(p);
	WRITE_OPCODE (WIREGL_VERTEXPOINTER_OPCODE);
}

void OPENGL_APIENTRY
WIREGL_PACK_FUNCTION( ColorPointer  )(GLint size, GLenum type, GLsizei stride, const GLvoid *p) {
	unsigned char *data_ptr;
	GET_BUFFERED_POINTER ( 8);
	WRITE_DATA( 0, GLint, size);
	WRITE_DATA( 4, GLenum, type);
	WIREGL_UNUSED(stride);
	WIREGL_UNUSED(p);
	WRITE_OPCODE (WIREGL_COLORPOINTER_OPCODE);
}

void OPENGL_APIENTRY
WIREGL_PACK_FUNCTION( IndexPointer  )(GLenum type, GLsizei stride, const GLvoid *p) {
	unsigned char *data_ptr;
	GET_BUFFERED_POINTER ( 4);
	WRITE_DATA( 0, GLenum, type);
	WIREGL_UNUSED(stride);
	WIREGL_UNUSED(p);
	WRITE_OPCODE (WIREGL_INDEXPOINTER_OPCODE);
}

void OPENGL_APIENTRY
WIREGL_PACK_FUNCTION( NormalPointer  )(GLenum type, GLsizei stride, const GLvoid *p) {
	unsigned char *data_ptr;
	GET_BUFFERED_POINTER ( 4);
	WRITE_DATA( 0, GLenum, type);
	WIREGL_UNUSED(stride);
	WIREGL_UNUSED(p);
	WRITE_OPCODE (WIREGL_NORMALPOINTER_OPCODE);
}

void OPENGL_APIENTRY
WIREGL_PACK_FUNCTION( TexCoordPointer  )(GLint size, GLenum type, GLsizei stride, const GLvoid *p) {
	unsigned char *data_ptr;
	GET_BUFFERED_POINTER ( 8);
	WRITE_DATA( 0, GLint, size);
	WRITE_DATA( 4, GLenum, type);
	WIREGL_UNUSED(stride);
	WIREGL_UNUSED(p);
	WRITE_OPCODE (WIREGL_TEXCOORDPOINTER_OPCODE);
}

void OPENGL_APIENTRY
WIREGL_PACK_FUNCTION( EdgeFlagPointer  )(GLsizei stride, const GLvoid *p) {
	WIREGL_UNUSED(stride);
	WIREGL_UNUSED(p);
	WRITE_OPCODE (WIREGL_EDGEFLAGPOINTER_OPCODE);
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( DrawArrays )(GLenum mode, GLint first, GLsizei count) 
{
	unsigned char *data_ptr;
	GET_BUFFERED_POINTER (12);
	WRITE_DATA( 0, GLenum, mode);
	WRITE_DATA( 0, GLint, first);
	WRITE_DATA( 0, GLsizei, count);
	WRITE_OPCODE (WIREGL_DRAWARRAYS_OPCODE);
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( ArrayElement   )(GLint index) 
{
	unsigned char *data_ptr;
	GET_BUFFERED_POINTER (4);
	WRITE_DATA( 0, GLint, index);
	WRITE_OPCODE (WIREGL_ARRAYELEMENT_OPCODE);
}

