##
## 3/06/2001
## http://graphics.stanford.edu/software/wiregl
##
## Copyright 2001
## The Board of Trustees of The Leland Stanford Junior University.
## All rights reserved.
##
## Except for commercial resale, lease, license or other commercial
## transactions, permission is hereby given to use, copy, and/or
## modify this software, provided that the above copyright notice and
## this permission notice appear in all copies of this software.  No
## part of this software or any derivatives thereof may be used in
## graphics systems for resale or for use in a commercial product.
##
## This software is provided "as is" and without warranty of any kind,
## express, implied or otherwise, including without limitation, any
## warranty of merchantability or fitness for a particular purpose.
##

import sys;
import cPickle;
import string;
import re;

import wiregl_common;

parsed_file = open( "gl_header.parsed", "rb" )
gl_mapping = cPickle.load( parsed_file )

print """

/*
** 3/06/2001
** http://graphics.stanford.edu/software/wiregl
**
** Copyright 2001
** The Board of Trustees of The Leland Stanford Junior University.
** All rights reserved.
**
** Except for commercial resale, lease, license or other commercial
** transactions, permission is hereby given to use, copy, and/or
** modify this software, provided that the above copyright notice and
** this permission notice appear in all copies of this software.  No
** part of this software or any derivatives thereof may be used in
** graphics systems for resale or for use in a commercial product.
**
** This software is provided "as is" and without warranty of any kind,
** express, implied or otherwise, including without limitation, any
** warranty of merchantability or fitness for a particular purpose.
*/


#include <stdio.h>
#include <assert.h>
#include "wiregl/include/wiregl_client.h"
#include "wiregl/glcontext/glhw.h"
#include "wiregl/glcontext/glcontext.h"
"""

keys = gl_mapping.keys()
keys.sort();

for func_name in keys:
    print "void *" + wiregl_common.DoImmediateMapping( func_name ) + " = NULL;"
print ""

print "#define X(a) { \"gl\" # a, (GLfunc *) &__glim_##a }"
print ""
print "GLjumptable wiregl_im_api[] = {"

for index in range(0,len(keys)):
    func_name = keys[index]
    print "\tX(" + func_name + "),"

print "\t{ NULL, NULL }"
print "};"
print ""

print "#undef X"
print ""

print "#define X(a) { \"gl\" # a, (GLfunc) __glpack_##a }"
print ""

print "GLapi wiregl_pack_api[] = {"

for index in range(0,len(keys)):
    func_name = keys[index]
    print "\tX(" + func_name + "),"

print "\t{ NULL, NULL }"
print "};"
print ""

print "#undef X"
print ""

