#ifndef WIREGL_SERIAL_H
#define WIREGL_SERIAL_H

#ifdef WINDOWS
typedef HANDLE WireGLSerialPort;
#define WIREGL_SERIAL_INVALID_PORT  (0)  /*INVALID_HANDLE*/
#else
typedef int    WireGLSerialPort;
#define WIREGL_SERIAL_INVALID_PORT  (-1)
#endif

#define WIREGL_SERIAL_READ  0x1
#define WIREGL_SERIAL_WRITE 0x2

UTIL_DECL WireGLSerialPort wireGLSerialOpen( const char *name, int mode, int baud );
UTIL_DECL int  wireGLSerialRead( WireGLSerialPort port, void *buf, int n );
UTIL_DECL int  wireGLSerialWrite( WireGLSerialPort port, void *buf, int n );
UTIL_DECL void wireGLSerialShowState( WireGLSerialPort port );

#endif /* WIREGL_SERIAL_H */
