/*
** 3/06/2001
** http://graphics.stanford.edu/software/wiregl
**
** Copyright 2001
** The Board of Trustees of The Leland Stanford Junior University.
** All rights reserved.
**
** Except for commercial resale, lease, license or other commercial
** transactions, permission is hereby given to use, copy, and/or
** modify this software, provided that the above copyright notice and
** this permission notice appear in all copies of this software.  No
** part of this software or any derivatives thereof may be used in
** graphics systems for resale or for use in a commercial product.
**
** This software is provided "as is" and without warranty of any kind,
** express, implied or otherwise, including without limitation, any
** warranty of merchantability or fitness for a particular purpose.
*/

#ifndef WIREGL_PIPE_H
#define WIREGL_PIPE_H

#ifdef WINDOWS
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#endif


#ifndef NO_INCLUDE_GLCONTEXT_STUFF
#include "wiregl/glcontext/glcontext.h"
#else
struct GLcontext;
#endif

#include "wiregl/include/wiregl_util.h"
#include "wiregl/include/wiregl_protocol.h"
#include "wiregl/include/wiregl_feather.h"
#include "wiregl/include/wiregl_opcodes.h"
#include "wiregl/include/wiregl_common.h"
#include "wiregl/include/wiregl_lightning2.h"
#include "wiregl/include/wiregl_serial.h"

#if defined( IRIX ) || defined( IRIX64 ) || defined( Linux) || defined(AIX)
#include <X11/Xlib.h>
#include <X11/Xutil.h>
typedef void *GLXContext;
#endif

typedef struct WireGLPipeExtent {
	int x1, y1;
	int x2, y2;
} WireGLPipeExtent;

typedef struct WireGLPipeDisplay {
	char name[WIREGL_MAX_DISPLAY_NAME_LEN];
	int L2;
	int port;
	int channel;
	WireGLConnection *conn;
	int x, y, w, h;
	int rotate_color;
	float colormatrix[12];
} WireGLPipeDisplay;

typedef struct WireGLPipe {

	unsigned short port;

	int no_graphics;
	int pipe_num;

	int use_L2;
	int use_vis;
	int vis_send_swaps;
	int vis_sync;
	int actual_window_width, actual_window_height;
	int window_width, window_height;
	int window_x, window_y;
	int num_pipes;
	int rotate_color_flag;
	int rotate_color;
	float colormatrix[12];

	struct {
		int           single_buffer;
		int           frame_num;
		WireGLL2Frame frame[2];
		struct {
			char             *name;
			int               baud;
			WireGLSerialPort  port;
		} back_channel;
	} L2;

	int num_extents;
	WireGLPipeExtent extent[WIREGL_MAX_EXTENTS];
	int mural_w,  mural_h;
	int apply_viewtransform;
	GLrectf *current_bounds;

	int num_displays;
	WireGLPipeDisplay display[WIREGL_MAX_DISPLAYS];

	unsigned int fullscreen;
	unsigned int depth_bits;
	unsigned int stencil_bits;
	WireGLFeatherParam feather;
	WireGLConnection *barrier_conn;
	int swap_barrier;
	int          debug;

	int log;
	WireGLTimer *timer;
	WireGLTimer *world_time;
	int			 optimize_bucket;

	int distrib_textures;

#ifdef WINDOWS
	HWND         hWnd;
	HGLRC        hRC;
	HDC          device_context;
#else
	Display     *dpy;
	XVisualInfo *visual;
	GLXContext   context;
	Window       window;
	char        *display_string;
	int          try_direct;
	int          force_direct;
	int          sync;
#endif
} WireGLPipe;

extern WireGLPipe wiregl_pipe;

typedef struct WireGLReceiveBuffer {
	WireGLConnection *conn;
	unsigned int   	  length;
	void           	 *buffer;

	struct WireGLReceiveBuffer *next;
} WireGLReceiveBuffer;

typedef struct WireGLWorkQueueExtent {
	GLrecti outputwindow;
	GLrecti imagewindow;
	GLrectf bounds;
	int     display;
} WireGLWorkQueueExtent;

typedef struct WireGLWorkQueue {
	GLcontext *context;
	GLrecti imagespace;
	int     num_extents;
	WireGLWorkQueueExtent extent[WIREGL_MAX_EXTENTS];
	int apply_viewtransform;
	WireGLReceiveBuffer *head;
	WireGLReceiveBuffer *tail;
	int blocked;
	int delete_when_done;
	WireGLConnection *conn;
	WireGLConnection *peer_conn;
	struct WireGLWorkQueue *next, *prev;
} WireGLWorkQueue;

WireGLWorkQueue *__currentWorkQueue( void );

extern WireGLHashTable *PAPIbarriers, *PAPIsemaphores;

void wireGLInitNormalLookupTable( void );

#ifdef WINDOWS
void wireGLServiceMain ( void );
int  wireGLInstallService ( void );
int  wireGLRemoveService ( void );
#endif

void wireGLPipeserverConnect( WireGLConnection *conn, WireGLConnectionRequest *request );
void wireGLPipeserverReceive( WireGLConnection *conn, void *buf, unsigned int len );

void wireGLCreateWindow( void );
void wireGLPipeKillWindow( void );
void wireGLRenderRemoteStreams( void );
void wireGLDeviceSwapBuffers( void );

void __decodeBoundsInfo ( void );

void wireGLLoadTARGATexture( char *filename );

void wireGLPipeParseConfig( char *fname );

typedef void (*wiregl_decoder)( void );
extern wiregl_decoder wiregl_decode_functions[];
extern unsigned char *unpacker_data_ptr;
extern unsigned char *unpacker_opcode_ptr;
extern WireGLWorkQueue *__currentQueue;

#define READ_DATA( offset, type ) \
	*( (type *) (unpacker_data_ptr + (offset)))

#ifdef WIREGL_UNALIGNED_ACCESS_OKAY
#define READ_DOUBLE( offset ) \
	READ_DATA( offset, GLdouble )
#else
#define READ_DOUBLE( offset ) \
	wireGLReadUnalignedDouble( unpacker_data_ptr + (offset) )
#endif

#define DATA_POINTER( offset, type ) \
	( (type *) (unpacker_data_ptr + (offset)) )

#define INCR_DATA_PTR( delta ) \
	unpacker_data_ptr += (delta)

#define INCR_DATA_PTR_NO_ARGS() \
	INCR_DATA_PTR( 4 )

#define INCR_VAR_PTR() \
	INCR_DATA_PTR( *((int *) unpacker_data_ptr ) )

#define WIREGL_TRACK_DEPTH_COMPLEXITY 0

const char *wireGLOpcodeName( WireGLOpcode opcode );
void wireGLPrintFunc( WireGLOpcode opcode, unsigned char *unpacker_data_ptr );

#endif /* WIREGL_PIPE_H */
