/*
** 3/06/2001
** http://graphics.stanford.edu/software/wiregl
**
** Copyright 2001
** The Board of Trustees of The Leland Stanford Junior University.
** All rights reserved.
**
** Except for commercial resale, lease, license or other commercial
** transactions, permission is hereby given to use, copy, and/or
** modify this software, provided that the above copyright notice and
** this permission notice appear in all copies of this software.  No
** part of this software or any derivatives thereof may be used in
** graphics systems for resale or for use in a commercial product.
**
** This software is provided "as is" and without warranty of any kind,
** express, implied or otherwise, including without limitation, any
** warranty of merchantability or fitness for a particular purpose.
*/

#ifndef WIREGL_PAPI_H
#define WIREGL_PAPI_H

#ifndef WINDOWS
#define OPENGL_APIENTRY
#else
#ifndef OPENGL_APIENTRY
#define OPENGL_APIENTRY __stdcall
#endif
#endif

#include "wiregl/include/wiregl_const.h"

#ifdef __cplusplus
extern "C" {
#endif

void OPENGL_APIENTRY glBarrierCreate( GLuint name, GLuint count );
void OPENGL_APIENTRY glBarrierDestroy( GLuint name );
void OPENGL_APIENTRY glBarrierExec( GLuint name );
void OPENGL_APIENTRY glSemaphoreCreate( GLuint name, GLuint count );
void OPENGL_APIENTRY glSemaphoreDestroy( GLuint name );
void OPENGL_APIENTRY glSemaphoreP( GLuint name );
void OPENGL_APIENTRY glSemaphoreV( GLuint name );

void OPENGL_APIENTRY wireGLCreateContext( void );
void OPENGL_APIENTRY wireGLMakeCurrent( void );
void OPENGL_APIENTRY wireGLSwapBuffers( void );
void OPENGL_APIENTRY wireGLUseSystemGL( void );
void OPENGL_APIENTRY wireGLGetIntegerv( GLuint pname, GLint *params );
void OPENGL_APIENTRY wireGLSyncWithL2( void );

#ifdef __cplusplus
}
#endif

#endif /* WIREGL_PAPI_H */

