#ifndef WIREGL_LIGHTNING2_H
#define WIREGL_LIGHTNING2_H

/* Lighting2 Strip Header Functions */

#ifdef WINDOWS
typedef unsigned __int64   WireGLL2StripHeader;
#else
typedef unsigned long long WireGLL2StripHeader;
#endif

#define WIREGL_L2_DOUBLE_BUFFER_A	0
#define WIREGL_L2_DOUBLE_BUFFER_B	1
#define WIREGL_L2_SINGLE_BUFFER     2

typedef struct WireGLL2Header {

    unsigned int        win_x;
    unsigned int        win_y;
    WireGLL2StripHeader strip;

} WireGLL2Header;

typedef struct WireGLL2Extent {

    unsigned int win_x1;
    unsigned int win_y1;
    unsigned int win_x2;
    unsigned int win_y2;

    float        tex_x1;
    float        tex_y1;
    float        tex_x2;
    float        tex_y2;

} WireGLL2Extent;

typedef struct WireGLL2Frame {

    unsigned int    tex_id;
    unsigned int    tex_w;
    unsigned int    tex_h;
    unsigned char  *tex_data;

    unsigned int    num_extents;
    unsigned int    max_extents;
    WireGLL2Extent *extent;

    unsigned int    num_headers;
    unsigned int    max_headers;
    WireGLL2Header *header;

} WireGLL2Frame;

void wireGLL2Sync( int phase );
void wireGLL2Wait( void );

/* can't have the typedef already */
struct WireGLWorkQueue;
void wireGLL2MakeFrame( WireGLL2Frame *frame, int buffer,
						struct WireGLWorkQueue *q );
void wireGLL2DrawFrame( WireGLL2Frame *frame );

#endif /* WIREGL_LIGHTNING2_H */

