/*
** 3/06/2001
** http://graphics.stanford.edu/software/wiregl
**
** Copyright 2001
** The Board of Trustees of The Leland Stanford Junior University.
** All rights reserved.
**
** Except for commercial resale, lease, license or other commercial
** transactions, permission is hereby given to use, copy, and/or
** modify this software, provided that the above copyright notice and
** this permission notice appear in all copies of this software.  No
** part of this software or any derivatives thereof may be used in
** graphics systems for resale or for use in a commercial product.
**
** This software is provided "as is" and without warranty of any kind,
** express, implied or otherwise, including without limitation, any
** warranty of merchantability or fitness for a particular purpose.
*/

#ifndef WIREGL_COMMON_H
#define WIREGL_COMMON_H

#include "wiregl/include/wiregl_feather.h"

#define WIREGL_MAX_EXTENTS 256
#define WIREGL_REQUEST_PEER_NAME_LENGTH 1024

#define WIREGL_MAX_DISPLAYS 32
#define WIREGL_MAX_DISPLAY_NAME_LEN 1024

typedef struct WireGLConnectionRequestExtent {
	int x1, y1;
	int x2, y2;
} WireGLConnectionRequestExtent;

typedef struct WireGLConnectionRequestDisplay {
	char  name[WIREGL_MAX_DISPLAY_NAME_LEN];
	int   x;
	int   y;
	int   w;
	int   h;
	int   rotate_color;
	float colormatrix[12];
} WireGLConnectionRequestDisplay;

typedef struct WireGLConnectionRequest {

    unsigned int  magic;
	unsigned int  size;
	
    unsigned int  max_send;
    int           window_x, window_y;
	unsigned int  depth_bits;
	unsigned int  stencil_bits;
	WireGLFeatherParam feather;
    unsigned int  please_use_gm;
	unsigned int  gm_node_id;
	unsigned int  gm_port_num;

	int L2_single_buffer;
	int vis_send_swaps;
	int num_pipes;
	int pipe_num;

	int                           num_extents;
	WireGLConnectionRequestExtent extent[WIREGL_MAX_EXTENTS];

	int	 mural_w,  mural_h;
	int  apply_viewtransform;

	char peer[WIREGL_REQUEST_PEER_NAME_LENGTH];

	int num_displays;
	WireGLConnectionRequestDisplay display[WIREGL_MAX_DISPLAYS];

	int rotate_color;
	float colormatrix[12];
	int optimize_bucket;

} WireGLConnectionRequest;

typedef struct WireGLConnectionResponse {

    unsigned int magic;
	unsigned int size;

    unsigned int max_send;
    unsigned int client_id;
    unsigned int gm_node_id;
	unsigned int gm_port_num;
} WireGLConnectionResponse;

#define WIREGL_CONNECTION_MAGIC   0x77697265
#define WIREGL_TCPIP_DEFAULT_PORT       7000
#define WIREGL_PIPESERVER_BARRIER         69

#ifdef WINDOWS

#include <windows.h>
static const PIXELFORMATDESCRIPTOR wiregl_pfd = {
    sizeof(wiregl_pfd),   /* nSize */
    1,                    /* nVersion */
    PFD_DRAW_TO_WINDOW | 
    PFD_SUPPORT_OPENGL | PFD_DOUBLEBUFFER,   /* dwFlags */
    PFD_TYPE_RGBA,        /* iPixelType */
    32,                   /* cColorBits */
    8,                    /* cRedBits */
    24,                   /* cRedShift */ 
    8,                    /* cGreenBits */    
    16,                   /* cGreenShift */
    8,                    /* cBlueBits */
    8,                    /* cBlueShift */
    8,                    /* cAlphaBits */
    0,                    /* cAlphaShift */
    0,                    /* cAccumBits */
    0,                    /* cAccumRedBits */
    0,                    /* cAccumGreenBits */
    0,                    /* cAccumBlueBits */
    0,                    /* cAccumAlphaBits */
    32,                   /* cDepthBits */
    8,                    /* cStencilBits */
    0,                    /* cAuxBuffers */
    PFD_MAIN_PLANE,       /* iLayerType */
    0,                    /* bReserved */
    0,                    /* dwLayerMask */
    0,                    /* dwVisableMask */
    0                     /* dwDamageMask */
};
    
#endif


#endif /* WIREGL_COMMON_H */
