/*
** 3/06/2001
** http://graphics.stanford.edu/software/wiregl
**
** Copyright 2001
** The Board of Trustees of The Leland Stanford Junior University.
** All rights reserved.
**
** Except for commercial resale, lease, license or other commercial
** transactions, permission is hereby given to use, copy, and/or
** modify this software, provided that the above copyright notice and
** this permission notice appear in all copies of this software.  No
** part of this software or any derivatives thereof may be used in
** graphics systems for resale or for use in a commercial product.
**
** This software is provided "as is" and without warranty of any kind,
** express, implied or otherwise, including without limitation, any
** warranty of merchantability or fitness for a particular purpose.
*/

#ifndef WIREGL_BARRIER_H
#define WIREGL_BARRIER_H

#include "wiregl/include/wiregl_util.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef enum {
	BARRIER_CREATE_BARRIER = 0,
	BARRIER_ENTER_BARRIER = 1,
	BARRIER_QUIT = 2
} BarrierOpcode;

#define BARRIER_PORT 15000

WireGLConnection *wireGLBarrierConnect( char *server );
void wireGLBarrierEnter( WireGLConnection *conn, int barrier_num );
void wireGLBarrierCreate( WireGLConnection *conn, int barrier_num, int barrier_size );

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* WIREGL_BARRIER_H */
