##
## 3/06/2001
## http://graphics.stanford.edu/software/wiregl
##
## Copyright 2001
## The Board of Trustees of The Leland Stanford Junior University.
## All rights reserved.
##
## Except for commercial resale, lease, license or other commercial
## transactions, permission is hereby given to use, copy, and/or
## modify this software, provided that the above copyright notice and
## this permission notice appear in all copies of this software.  No
## part of this software or any derivatives thereof may be used in
## graphics systems for resale or for use in a commercial product.
##
## This software is provided "as is" and without warranty of any kind,
## express, implied or otherwise, including without limitation, any
## warranty of merchantability or fitness for a particular purpose.
##

require 'glcurrent_types.pl';

print <<EOF;
/*
** 3/06/2001
** http://graphics.stanford.edu/software/wiregl
**
** Copyright 2001
** The Board of Trustees of The Leland Stanford Junior University.
** All rights reserved.
**
** Except for commercial resale, lease, license or other commercial
** transactions, permission is hereby given to use, copy, and/or
** modify this software, provided that the above copyright notice and
** this permission notice appear in all copies of this software.  No
** part of this software or any derivatives thereof may be used in
** graphics systems for resale or for use in a commercial product.
**
** This software is provided "as is" and without warranty of any kind,
** express, implied or otherwise, including without limitation, any
** warranty of merchantability or fitness for a particular purpose.
*/

/* Generated by glcurrent_header.pl */
#ifndef GLCURRENT_POINTERS_H
#define GLCURRENT_POINTERS_H

EOF

foreach $k (keys (%hash)) {
	$name = lc $k;
	print "typedef struct {\n";
	print "\tunsigned char *ptr;\n";
	foreach $type (@ {$hash{$k}{types}}) {
		foreach $size (@ {$hash{$k}{sizes}}) {
			print "\tunsigned char *";
			print $type;
			print $size;
			print ";\n";
		}
	}
	print "} GL".$name."_p;\n\n";
}


print "typedef struct {\n";
# Create the data structures
foreach $k (keys (%hash)) {
	$name = lc $k;
	print "\tGL".$name."_p\t".$name.";\n";
}

print <<EOF
	unsigned char *vtx_op;
	unsigned char *vtx_data;
	unsigned char *begin_op;
	unsigned char *begin_data;
	unsigned int vtx_count;
	unsigned int vtx_max;
	unsigned int vtx_count_begin;

} GLcurrent;



#endif
EOF
