ifneq ($(ARCH), WIN_NT)
ifneq ($(ARCH), WIN_98)
ARCH=$(shell uname | sed -e 's/-//g')
endif
endif

ECHO := echo

include $(WORK_ROOT)/config/$(ARCH).mk

###########################
# LEAVE THESE THINGS ALONE!
###########################

ifdef PROGRAM
BUILDDIR := $(WORK_ROOT)/built/$(PROGRAM)
else
ifdef LIBRARY
BUILDDIR := $(WORK_ROOT)/built/$(LIBRARY)
else
BUILDDIR := dummy_builddir
endif
endif

ifdef MPI
HUMPER_CC = $(MPI_CC)
HUMPER_CXX = $(MPI_CXX)
MPI_STRING = (MPI)
LDFLAGS += $(MPI_LDFLAGS)
else
HUMPER_CC = $(CC)
HUMPER_CXX = $(CXX)
endif

ifdef VTK
VTK_STRING = (VTK)
ifdef WINDOWS
CXXFLAGS += -Ic:/vtk31/graphics -Ic:/vtk31/common -Ic:/vtk31/imaging -Ic:/vtk31/local
LDFLAGS += c:/vtkbin/Debug/lib/vtkCommon.lib c:/vtkbin/Debug/lib/vtkContrib.lib c:/vtkbin/Debug/lib/vtkGraphics0.lib c:/vtkbin/Debug/lib/vtkGraphics1.lib c:/vtkbin/Debug/lib/vtkGraphics2.lib c:/vtkbin/Debug/lib/vtkGraphics3.lib c:/vtkbin/Debug/lib/vtkGraphics4.lib c:/vtkbin/Debug/lib/vtkImaging.lib 
else
error VTK on non-windows platform?
endif
endif

ifdef GLUT
ifdef WINDOWS
LDFLAGS += glut32.lib
else
LDFLAGS += -L/usr/X11R6/lib -lglut
endif
OPENGL = 1
endif

ifdef OPENGL
ifdef WINDOWS
LDFLAGS += glu32.lib opengl32.lib
else
LDFLAGS += -L/usr/X11R6/lib -lGLU -lGL -lXmu -lXi -lX11
endif
endif


OBJDIR := $(BUILDDIR)/$(ARCH)
DEPDIR := $(BUILDDIR)/$(ARCH)/dependencies
BINDIR := $(WORK_ROOT)/bin/$(ARCH)
ifndef DSO_DIR
ifdef WINDOWS
DSO_DIR := $(BINDIR)
else
DSO_DIR := $(WORK_ROOT)/lib/$(ARCH)
endif
endif

define MAKE_OBJDIR
	if test ! -d $(OBJDIR); then $(MKDIR) $(OBJDIR); fi
endef

define MAKE_BINDIR
	if test ! -d $(BINDIR); then $(MKDIR) $(BINDIR); fi
endef

define MAKE_DEPDIR
	if test ! -d $(DEPDIR); then $(MKDIR) $(DEPDIR); fi
endef

define MAKE_DSODIR
	if test ! -d $(DSO_DIR); then $(MKDIR) $(DSO_DIR); fi
endef

ifdef TEST
FILES := $(TEST)
endif

DEPS    := $(addprefix $(DEPDIR)/, $(FILES))
DEPS    := $(addsuffix .depend, $(DEPS))
OBJS    := $(addprefix $(OBJDIR)/, $(FILES))
OBJS    := $(addsuffix $(OBJSUFFIX), $(OBJS))
ifdef LIBRARY
LIBNAME := $(addprefix $(OBJDIR)/, $(LIBPREFIX)$(LIBRARY)$(DLLSUFFIX))
else
LIBNAME := dummy_libname
endif

ifndef TEXFILE
TEXFILE := $(NOWEBFILE:.nw=.tex)
endif

DVIFILE := $(TEXFILE:.tex=.dvi)
PSFILE := $(TEXFILE:.tex=.ps)
LJ4FILE := $(TEXFILE:.tex=.lj4)
TEXCRAP := lj4.out *.aux *.toc *.log *.bbl *.blg
TEMPFILES := *~ \\\#*\\\#

ifdef PROGRAM
PROG_TARGET := $(BINDIR)/$(PROGRAM)
TARGET := $(PROGRAM)
# ifdef WINDOWS
# LDFLAGS += /Fd$(PROG_TARGET:=.pdb)
# endif
else
PROG_TARGET := dummy_prog_target
endif

ifdef LIBRARY
TARGET := $(LIBPREFIX)$(LIBRARY)$(DLLSUFFIX)
# ifdef WINDOWS
# LDFLAGS += /Fd$(DSO_DIR)/$(TARGET:$(DLLSUFFIX)=.pdb)
# endif
endif

ifndef TARGET
TARGET := NOTHING
ifdef TEXFILE
TARGET := $(DVIFILE)
endif
endif

ifeq ($(INCLUDEDEPS), 1)
ifneq ($(DEPS)HACK, HACK)
include $(DEPS)
endif
endif

INCLUDE_DIRS += -I$(WORK_ROOT) -I. -I/usr/X11R6/include

PRINT_COMMAND := lpr

ifeq ($(HUMPER_AT_STANFORD),1)
INCLUDE_DIRS += -I/usr/graphics/include -I/usr/common/include
LDFLAGS += -L/usr/common/lib32 -L/usr/graphics/lib32
endif


ifeq ($(HUMPER_AT_AHPAH),1)
PRINT_COMMAND := prtps
endif

CFLAGS += -D$(ARCH) -DHUMPER_MAKE_SYSTEM $(INCLUDE_DIRS)
CXXFLAGS += -D$(ARCH) -DHUMPER_MAKE_SYSTEM $(INCLUDE_DIRS)

ifdef LESSWARN
WARN_STRING = (NOWARN)
else
CFLAGS += $(FULLWARN)
endif

ifdef RELEASE
CFLAGS += $(RELEASEFLAGS)
CXXFLAGS += $(RELEASEFLAGS)
LDFLAGS += $(RELEASEFLAGS)
RELEASE_STRING = (RELEASE)
RELEASE_FLAGS = "RELEASE=1"
else
ifdef PROFILE
CFLAGS += $(DEBUGFLAGS) $(PROFILEFLAGS)
CXXFLAGS += $(DEBUGFLAGS) $(PROFILEFLAGS)
LDFLAGS += $(DEBUGFLAGS) $(PROFILEFLAGS)
RELEASE_STRING = (PROFILE)
else
CFLAGS += $(DEBUGFLAGS)
CXXFLAGS += $(DEBUGFLAGS)
LDFLAGS += $(DEBUGFLAGS)
RELEASE_STRING = (DEBUG)
endif
endif

ifdef WINDOWS
LDFLAGS += /link /incremental:no /pdb:none
ifndef RELEASE
LDFLAGS += /debug
endif
endif

ifndef PROGRAM
ifndef LIBRARY
ifndef SUBDIRS
justtexme: arch $(TARGET)
endif
endif
endif

ifndef SUBDIRS
all: arch nowebstuff dep
recurse: $(PROG_TARGET) $(LIBNAME)
else
SUBDIRS_ALL = $(foreach dir, $(SUBDIRS), $(dir).subdir)

subdirs: $(SUBDIRS_ALL)

$(SUBDIRS_ALL):
	@$(MAKE) -C $(basename $@) $(RELEASE_FLAGS)
endif

release:
	@$(MAKE) RELEASE=1

profile:
	@$(MAKE) PROFILE=1

arch: $(PRECOMP)
	@$(ECHO) "-------------------------------------------------------------------------------"
ifndef NOWEBFILE
ifdef TEXFILE
	@$(ECHO) "                           Building $(TARGET)"
endif
endif
ifdef PROGRAM
	@$(ECHO) "              Building $(TARGET) for $(ARCH) $(RELEASE_STRING) $(MPI_STRING) $(VTK_STRING) $(WARN_STRING)"
endif
ifdef LIBRARY
	@$(ECHO) "              Building $(TARGET) for $(ARCH) $(RELEASE_STRING) $(MPI_STRING) $(VTK_STRING) $(WARN_STRING)"
endif
	@$(ECHO) "-------------------------------------------------------------------------------"
ifneq ($(BUILDDIR), dummy_builddir)
	@$(MAKE_BINDIR)
	@$(MAKE_OBJDIR)
	@$(MAKE_DEPDIR)
	@$(MAKE_DSODIR)
endif

ifdef WINDOWS

LIBRARIES := $(foreach lib,$(LIBRARIES),$(WORK_ROOT)/built/$(lib)/$(ARCH)/$(LIBPREFIX)$(lib)$(DLLSUFFIX))
LIBRARIES := $(LIBRARIES:$(DLLSUFFIX)=$(LIBSUFFIX))

else

LDFLAGS += -L$(DSO_DIR)
LIBRARIES := $(foreach lib,$(LIBRARIES),-l$(lib))

endif


ifndef NOWEBFILE
ifdef TEXFILE
nowebstuff: $(TARGET)
else
nowebstuff:
	@$(ECHO) -n ""
endif
else
nowebstuff:
	@$(ECHO) "Running noweb on $(NOWEBFILE) (to generate the source)";
	@$(NOWEB) -t $(NOWEBFILE)
endif

dep: $(DEPS)
	@$(MAKE) $(PARALLELMAKEFLAGS) recurse INCLUDEDEPS=1

$(PROG_TARGET): $(OBJS)
ifdef PROGRAM
	@$(ECHO) "Linking $(PROGRAM) for $(ARCH)"
ifdef WINDOWS
	@$(HUMPER_CXX) $(OBJS) /Fe$(PROG_TARGET)$(EXESUFFIX) $(LIBRARIES) $(LDFLAGS)
else
	@$(HUMPER_CXX) $(OBJS) -o $(PROG_TARGET)$(EXESUFFIX) $(LDFLAGS) $(LIBRARIES)
endif
	@$(ECHO) ""

endif

$(LIBNAME): $(OBJS) $(LIB_DEFS)
ifdef LIBRARY
	@$(ECHO) "Linking $@"
ifdef WINDOWS
	@$(LD) $(SHARED_LDFLAGS) /Fe$(LIBNAME) $(OBJS) $(LIBRARIES) $(LIB_DEFS) $(LDFLAGS)
else
ifdef AIXSHAREDLIB
	@$(ECHO) "AIX shared obj link"
	@$(ECHO) "Not using LDFLAGS $(LDFLAGS)"
	ar -ruv tmpAnyDX.a $(OBJS)
	nm -epC tmpAnyDX.a | awk -f $(WORK_ROOT)/scripts/exports.awk > tmpAnyDX.exp
	pwd
	ld -bnoentry -bloadmap:load.map -bM:SRE -o shr.o -bE:tmpAnyDX.exp tmpAnyDX.a -L$(WORK_ROOT)/bin/AIX $(SHARED_LDFLAGS) $(LIBRARIES) $(XSLIBS) -ldl -lm -lc
	ar qv $(LIBNAME) shr.o
	# rm -f tmpAnyDX.* shr.o
else
	@$(LD) $(SHARED_LDFLAGS) -o $(LIBNAME) $(OBJS) $(LDFLAGS) $(LIBRARIES)
endif
endif
ifndef DONT_COPY_DLL
	@$(CP) $(LIBNAME) $(DSO_DIR)
endif
endif

.SUFFIXES: .cpp .c .cxx .cc .C .s .l .tex .dvi .nw .ps .lj4

%.lj4: %.ps
	@$(ECHO) "Converting $< to $@"
	@$(ECHO) quit | $(GHOSTSCRIPT) -dQUIET -dNOPAUSE -sDEVICE=ljet4 -sOutputFile=$@ $<

%.pdf: %.ps
	@$(ECHO) "Running $(PS2PDF) on $<"
	@$(PS2PDF) $< $@

%.ps: %.dvi
	@$(ECHO) "Running $(DVIPS) on $<"
	@$(DVIPS) $< -o $@

%.dvi: %.tex $(TEXSUBFILES) $(BIBFILE)
	@$(ECHO) "Running $(LATEX) on $<"
	@$(LATEX) \\scrollmode \\input $<
ifdef BIBFILE
	@$(ECHO) "Running $(BIBTEX) on $(BIBFILE)"
	@$(BIBTEX) $(BIBFILE:.bib=)
	@$(ECHO) "Running $(LATEX) some more on $<"
	@$(LATEX) \\scrollmode \\input $<
endif
	@while grep -s 'Rerun to get cross-references right' $*.log; do	$(ECHO) "-------------------------------------------------------------------------------"; $(ECHO) "                   Running Latex again for cross-references...";	$(ECHO) "-------------------------------------------------------------------------------"; $(LATEX) \\scrollmode \\input $<; done

%.tex: %.nw
	@$(ECHO) "Running $(NOWEB) on $< (to generate the latex)"
	@$(NOWEB) -o $<

%.cpp: %.l
	@$(ECHO) "Creating $@"
	@$(LEX) $< > $@

%.cpp: %.y
	@$(ECHO) "Creating $@"
	@$(YACC) $<
	@$(MV) y.tab.c $@

%.tif: %.eps
	@$(ECHO) "Running ps2tiff on $<"
	@$(PS2TIFF) $(PS2TIFFOPTIONS) $< > $@

%.eps: %.jgr
	@$(ECHO) "Running jgraph on $<"
	@$(JGRAPH) $< > $@

$(DEPDIR)/%.depend: %.cpp
	@$(MAKE_DEPDIR)
	@$(ECHO) "Rebuilding dependencies for $<"
	@$(PERL) $(WORK_ROOT)/scripts/fastdep.pl $(INCLUDE_DIRS) --obj-prefix='$(OBJDIR)/' --extra-target=$@ $< > $@

$(DEPDIR)/%.depend: %.cxx
	@$(MAKE_DEPDIR)
	@$(ECHO) "Rebuilding dependencies for $<"
	@$(PERL) $(WORK_ROOT)/scripts/fastdep.pl $(INCLUDE_DIRS) --obj-prefix='$(OBJDIR)/' --extra-target=$@ $< > $@

$(DEPDIR)/%.depend: %.cc
	@$(MAKE_DEPDIR)
	@$(ECHO) "Rebuilding dependencies for $<"
	@$(PERL) $(WORK_ROOT)/scripts/fastdep.pl $(INCLUDE_DIRS) --obj-prefix='$(OBJDIR)/' --extra-target=$@ $< > $@

$(DEPDIR)/%.depend: %.C
	@$(MAKE_DEPDIR)
	@$(ECHO) "Rebuilding dependencies for $<"
	@$(PERL) $(WORK_ROOT)/scripts/fastdep.pl $(INCLUDE_DIRS) --obj-prefix='$(OBJDIR)/' --extra-target=$@ $< > $@

$(DEPDIR)/%.depend: %.c
	@$(MAKE_DEPDIR)
	@$(ECHO) "Rebuilding dependencies for $<"
	@$(PERL) $(WORK_ROOT)/scripts/fastdep.pl $(INCLUDE_DIRS) --obj-prefix='$(OBJDIR)/' --extra-target=$@ $< > $@

$(DEPDIR)/%.depend: %.s
	@$(MAKE_DEPDIR)
	@$(ECHO) "Rebuilding dependencies for $<"
	@$(PERL) $(WORK_ROOT)/scripts/fastdep.pl $(INCLUDE_DIRS) --obj-prefix='$(OBJDIR)/' --extra-target=$@ $< > $@

$(OBJDIR)/%.obj: %.cpp Makefile
	@$(ECHO) -n "Compiling "
	@$(HUMPER_CXX) /Fo$@ /c $(CXXFLAGS) $<

$(OBJDIR)/%.obj: %.c Makefile
	@$(ECHO) -n "Compiling "
	@$(HUMPER_CC) /Fo$@ /c $(CFLAGS) $<

$(OBJDIR)/%.o: %.cpp Makefile
	@$(ECHO) "Compiling $<"
	@$(HUMPER_CXX) -o $@ -c $(CXXFLAGS) $<

$(OBJDIR)/%.o: %.cxx Makefile
	@$(ECHO) "Compiling $<"
	@$(HUMPER_CXX) -o $@ -c $(CXXFLAGS) $<

$(OBJDIR)/%.o: %.cc Makefile
	@$(ECHO) "Compiling $<"
	@$(HUMPER_CXX) -o $@ -c $(CXXFLAGS) $<

$(OBJDIR)/%.o: %.C Makefile
	@$(ECHO) "Compiling $<"
	@$(HUMPER_CXX) -o $@ -c $(CXXFLAGS) $<

$(OBJDIR)/%.o: %.c Makefile
	@$(ECHO) "Compiling $<"
	@$(HUMPER_CC) -o $@ -c $(CFLAGS) $<

$(OBJDIR)/%.o: %.s Makefile
	@$(ECHO) "Assembling $<"
	@$(AS) -o $@ $<


###############
# Other targets
###############

print: $(PSFILE)
	@$(ECHO) "-------------------------------------------------------------------------------"
	@$(ECHO) "                     Printing $(PSFILE)"
	@$(ECHO) "-------------------------------------------------------------------------------"
	@$(PRINT_COMMAND) $(PSFILE)

clean:
ifdef SUBDIRS
	@for i in $(SUBDIRS); do $(MAKE) -C $$i clean; done
else
ifdef LIBRARY
	@$(ECHO) "Removing all $(ARCH) object files for $(LIBPREFIX)$(LIBRARY)$(LIBSUFFIX)."
else
ifdef PROGRAM
	@$(ECHO) "Removing all $(ARCH) object files for $(PROGRAM)."
endif
endif
	@$(RM) $(OBJS) $(TEXCRAP) $(TEMPFILES)
endif
ifdef NOWEBFILE
	@$(ECHO) "Removing all noweb crap for $(NOWEBFILE)."
	@$(RM) $(TEXFILE)
endif
ifdef TEXFILE
	@$(ECHO) "Cleaning up after TeX..."
	@$(RM) $(DVIFILE)
	@$(RM) $(PSFILE)
	@$(RM) $(LJ4FILE)
endif
ifneq ($(SLOP)HACK, HACK)
	@$(ECHO) "Also blowing away:    $(SLOP)"
	@$(RM) $(SLOP)
endif


ifdef SUBDIRS
clobber:
	@for i in $(SUBDIRS); do $(MAKE) -C $$i clobber; done
else
clobber: clean
ifdef LIBRARY
	@$(ECHO) "Removing $(LIBPREFIX)$(LIBRARY)$(LIBSUFFIX) for $(ARCH)."
	@$(RM) $(LIBNAME)
else
ifdef PROGRAM
	@$(ECHO) "Removing $(PROGRAM) for $(ARCH)."
	@$(RM) $(PROGRAM)
	@$(RM) $(BINDIR)/$(PROGRAM)
endif
endif
	@$(ECHO) "Removing dependency files (if any)"
	@$(RM) $(DEPDIR)/*.depend
endif
