/*
** 3/06/2001
** http://graphics.stanford.edu/software/wiregl
**
** Copyright 2001
** The Board of Trustees of The Leland Stanford Junior University.
** All rights reserved.
**
** Except for commercial resale, lease, license or other commercial
** transactions, permission is hereby given to use, copy, and/or
** modify this software, provided that the above copyright notice and
** this permission notice appear in all copies of this software.  No
** part of this software or any derivatives thereof may be used in
** graphics systems for resale or for use in a commercial product.
**
** This software is provided "as is" and without warranty of any kind,
** express, implied or otherwise, including without limitation, any
** warranty of merchantability or fitness for a particular purpose.
*/

#include "__utilsource.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "wiregl/include/wiregl_util.h"

static void 
useful_strncpy( char *dst, const char *src, int len )
{
	strncpy( dst, src, len );
	dst[len] = '\0';
}

static int
is_digit_string( const char *s )
{
	if ( !isdigit( *s ) )
	{
		return 0;
	}

	while ( *s && isdigit( *s ) )
	{
		s++;
	}

	return ( *s == 0 );
}

UTIL_DECL int 
wireGLParseURL( char *url, char *protocol, char *hostname,
				unsigned short *port, unsigned short default_port )
{
	char *temp, *temp2;

	/* pull off the protocol */
	temp = strstr( url, "://" );
	if ( temp == NULL )
	{
		goto bad_url;
	}
	useful_strncpy( protocol, url, temp-url );

	temp += 3;

	/* handle a trailing :<digits> to specify the port */

	/* there might be a filename here */
	temp2 = strrchr( temp, '/' );
	if ( temp2 == NULL )
	{
		temp2 = strrchr( temp, '\\' );
	}
	if ( temp2 == NULL )
	{
		temp2 = temp;
	}

	temp2 = strrchr( temp2, ':' );
	if ( temp2 )
	{
		useful_strncpy( hostname, temp, temp2 - temp );
		temp2++;
		if ( !is_digit_string( temp2 ) )
			goto bad_url;

		*port = (unsigned short) atoi( temp2 );
	}
	else
	{
		strcpy( hostname, temp );
		*port = default_port;
	}

	return 1;

 bad_url:
	wireGLWarning( WIREGL_WARN_CRITICAL, "URL: expected <protocol>://"
				   "<destination>[:<port>], what is \"%s\"?", url );
	return 0;
}
