/*
** 3/06/2001
** http://graphics.stanford.edu/software/wiregl
**
** Copyright 2001
** The Board of Trustees of The Leland Stanford Junior University.
** All rights reserved.
**
** Except for commercial resale, lease, license or other commercial
** transactions, permission is hereby given to use, copy, and/or
** modify this software, provided that the above copyright notice and
** this permission notice appear in all copies of this software.  No
** part of this software or any derivatives thereof may be used in
** graphics systems for resale or for use in a commercial product.
**
** This software is provided "as is" and without warranty of any kind,
** express, implied or otherwise, including without limitation, any
** warranty of merchantability or fitness for a particular purpose.
*/

#include "__utilsource.h"

#include <stdlib.h>
#if !defined(WINDOWS)
#include <unistd.h>
#include <limits.h>
#else
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <winbase.h>
#endif
#include "wiregl/include/wiregl_util.h"

UTIL_DECL void 
wireGLInitOS( void )
{
#if defined(WINDOWS)
	WORD wVersionRequested = MAKEWORD(2, 0);
	WSADATA wsaData;
	int err;

	err = WSAStartup(wVersionRequested, &wsaData);
	if (err != 0)
		wireGLError("Couldn't initialize sockets on WINDOWS");
#endif
}

UTIL_DECL void 
wireGLSleep( unsigned int msecs )
{
#if defined ( IRIX ) || defined( IRIX64 )
	sginap( (long) msecs * (CLK_TCK / 1000) );
#elif defined( WINDOWS )
	Sleep( msecs );
#elif defined( Linux ) || defined(AIX)
	usleep( msecs * 1000 );
#else
#error UNKNOWN SLEEPING ARCHITECTURE
#endif
}
