/*
** 3/06/2001
** http://graphics.stanford.edu/software/wiregl
**
** Copyright 2001
** The Board of Trustees of The Leland Stanford Junior University.
** All rights reserved.
**
** Except for commercial resale, lease, license or other commercial
** transactions, permission is hereby given to use, copy, and/or
** modify this software, provided that the above copyright notice and
** this permission notice appear in all copies of this software.  No
** part of this software or any derivatives thereof may be used in
** graphics systems for resale or for use in a commercial product.
**
** This software is provided "as is" and without warranty of any kind,
** express, implied or otherwise, including without limitation, any
** warranty of merchantability or fitness for a particular purpose.
*/

#include "__utilsource.h"

#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>

#include "wiregl/include/wiregl_util.h"

#if 0

static int __fileLength( char *path )
{
	struct stat st_buf;
	if ((stat( path, &st_buf )) == -1)
		wireGLSimpleError( "Couldn't stat %s", path );
	return st_buf.st_size;
}

static int wireGLFileReadExact( WireGLConnection *conn, int needed, void *_buf )
{
	if ( conn->file_buf + needed > conn->file_end )
		return 0;

	memcpy( _buf, conn->file_buf, needed );
	conn->file_buf += needed;
	return 1;
}

UTIL_DECL int wireGLFileReadMessage( WireGLConnection *conn, void *buf )
{
	int len;
	wireGLFileReadExact( conn, sizeof( len ), &len );
	wireGLFileReadExact( conn, len, buf );
	return len;
}

UTIL_DECL void wireGLFileSendMessage( WireGLConnection *conn, void *buf, int bytes )
{
	fwrite( &bytes, sizeof( bytes ), 1, conn->fp );
	fwrite( buf, bytes, 1, conn->fp );
}

UTIL_DECL WireGLConnection *wireGLAcceptFileClient( char *path )
{
	WireGLConnection *conn = (WireGLConnection *) wireGLAlloc( sizeof( *conn ) );
	int len;

	conn->type = WIREGL_FILE_TRACE;
	conn->fp = fopen( path, "rb" );
	if (conn->fp == NULL)
		wireGLSimpleError( "Couldn't open %s", path );

	len = __fileLength( path );

	// don't use wireGLAlloc here because it might say "no".
	//
	conn->file_buf = conn->file_start = (char *) malloc( len );
	conn->file_end = conn->file_start + len;
	fread( conn->file_start, len, 1, conn->fp );

	conn->SendMessage = wireGLFileSendMessage;
	conn->ReadMessage = wireGLFileReadMessage;
	return conn;
}

UTIL_DECL void wireGLProvideFileReceiveArea( void *buf, int len )
{
	WIREGL_UNUSED(buf);
	WIREGL_UNUSED(len);
}

UTIL_DECL void wireGLInitFileNet( WireGLConnection *conn, 
								  WireGLReceiveHandler receive, 
								  WireGLDisconnectHandler disconnect )
{
	WIREGL_UNUSED(conn);
	WIREGL_UNUSED(receive);
	WIREGL_UNUSED(disconnect);
	wireGLSimpleError( "wireGLInitFileNet: unsupported!" );
}

#endif
