/*
** 3/06/2001
** http://graphics.stanford.edu/software/wiregl
**
** Copyright 2001
** The Board of Trustees of The Leland Stanford Junior University.
** All rights reserved.
**
** Except for commercial resale, lease, license or other commercial
** transactions, permission is hereby given to use, copy, and/or
** modify this software, provided that the above copyright notice and
** this permission notice appear in all copies of this software.  No
** part of this software or any derivatives thereof may be used in
** graphics systems for resale or for use in a commercial product.
**
** This software is provided "as is" and without warranty of any kind,
** express, implied or otherwise, including without limitation, any
** warranty of merchantability or fitness for a particular purpose.
*/

#include "__utilsource.h"
#include "wiregl/include/wiregl_util.h"

UTIL_DECL char wireGLDetermineEndianness( void )
{
  union {
    struct {
      char c1;
      char c2;
      char c3;
      char c4;
    } c;
    unsigned int i;
  } e_test;

  e_test.c.c1 = 1;
  e_test.c.c2 = 2;
  e_test.c.c3 = 3;
  e_test.c.c4 = 4;

  if (e_test.i == 0x01020304)
		return WIREGL_BIG_ENDIAN;
	return WIREGL_LITTLE_ENDIAN;
}

UTIL_DECL void wireGLWriteUnalignedDouble( void *buffer, double d )
{
	unsigned int *ui = (unsigned int *) buffer;
	ui[0] = ((unsigned int *) &d)[0];
	ui[1] = ((unsigned int *) &d)[1];
}

UTIL_DECL double wireGLReadUnalignedDouble( void *buffer )
{
	unsigned int *ui = (unsigned int *) buffer;
	double d;
	((unsigned int *) &d)[0] = ui[0];
	((unsigned int *) &d)[1] = ui[1];
	return d;
}
