/*
** 3/06/2001
** http://graphics.stanford.edu/software/wiregl
**
** Copyright 2001
** The Board of Trustees of The Leland Stanford Junior University.
** All rights reserved.
**
** Except for commercial resale, lease, license or other commercial
** transactions, permission is hereby given to use, copy, and/or
** modify this software, provided that the above copyright notice and
** this permission notice appear in all copies of this software.  No
** part of this software or any derivatives thereof may be used in
** graphics systems for resale or for use in a commercial product.
**
** This software is provided "as is" and without warranty of any kind,
** express, implied or otherwise, including without limitation, any
** warranty of merchantability or fitness for a particular purpose.
*/

#include "__utilsource.h"

#include "wiregl/include/wiregl_util.h"

static struct {
	int                  initialized;
	int                  sender_id;
	WireGLBufferPool     bufpool;
	WireGLNetReceiveFunc recv;
	WireGLNetCloseFunc   close;
} wiregl_devnull;

UTIL_DECL void *
wireGLDevNullAlloc( void )
{
	void *buf = wireGLBufferPoolPop( &wiregl_devnull.bufpool );
	if ( buf == NULL )
	{
		buf = wireGLAlloc( __wiregl_max_send );
	}
	return buf;
}

UTIL_DECL void
wireGLDevNullFlowControl( WireGLConnection *conn, int enable )
{
	WIREGL_UNUSED(conn);
	WIREGL_UNUSED(enable);
}

UTIL_DECL void
wireGLDevNullFree( WireGLConnection *conn, void *buf )
{
	WIREGL_UNUSED(conn);
	WIREGL_UNUSED(buf);
}

UTIL_DECL void 
wireGLDevNullSend( WireGLConnection *conn, void **bufp,
				 void *start, unsigned int len )
{
	WIREGL_UNUSED(start);
	WIREGL_UNUSED(conn);
	WIREGL_UNUSED(len);

	/* reclaim this pointer for reuse and try to keep the client from
	   accidentally reusing it directly */
	wireGLBufferPoolPush( &wiregl_devnull.bufpool, *bufp );
	*bufp = NULL;
}

UTIL_DECL int
wireGLDevNullRecv( void )
{
	return 0;
}


UTIL_DECL void
wireGLDevNullInit( WireGLNetReceiveFunc recvFunc, WireGLNetCloseFunc closeFunc )
{
	if ( wiregl_devnull.initialized )
	{
		wireGLAssert( wiregl_devnull.recv == recvFunc );
		wireGLAssert( wiregl_devnull.close == closeFunc );
		return;
	}

	wireGLBufferPoolInit( &wiregl_devnull.bufpool, 16 );

	wiregl_devnull.recv   	   = recvFunc;
	wiregl_devnull.close  	   = closeFunc;
	wiregl_devnull.sender_id   = 0;

	wiregl_devnull.initialized = 1;
}

UTIL_DECL void 
wireGLDevNullConnection( WireGLConnection *conn )
{
	wireGLAssert( wiregl_devnull.initialized );

    conn->type      = WIREGL_DROP_PACKETS;
	conn->Alloc  	= wireGLDevNullAlloc;
	conn->Send   	= wireGLDevNullSend;
	conn->Free      = wireGLDevNullFree;
	conn->sender_id = wiregl_devnull.sender_id++;
}


