##
## 3/06/2001
## http://graphics.stanford.edu/software/wiregl
##
## Copyright 2001
## The Board of Trustees of The Leland Stanford Junior University.
## All rights reserved.
##
## Except for commercial resale, lease, license or other commercial
## transactions, permission is hereby given to use, copy, and/or
## modify this software, provided that the above copyright notice and
## this permission notice appear in all copies of this software.  No
## part of this software or any derivatives thereof may be used in
## graphics systems for resale or for use in a commercial product.
##
## This software is provided "as is" and without warranty of any kind,
## express, implied or otherwise, including without limitation, any
## warranty of merchantability or fitness for a particular purpose.
##

import sys;
import cPickle;
import types;
import string;
import re;

import wiregl_common;

parsed_file = open( "../opengl_stub/gl_header.parsed", "rb" )
gl_mapping = cPickle.load( parsed_file )

print "/* pipe_server/decode.c -- auto-generated by pipe_server/unpacker.py */"

print """

/*
** 3/06/2001
** http://graphics.stanford.edu/software/wiregl
**
** Copyright 2001
** The Board of Trustees of The Leland Stanford Junior University.
** All rights reserved.
**
** Except for commercial resale, lease, license or other commercial
** transactions, permission is hereby given to use, copy, and/or
** modify this software, provided that the above copyright notice and
** this permission notice appear in all copies of this software.  No
** part of this software or any derivatives thereof may be used in
** graphics systems for resale or for use in a commercial product.
**
** This software is provided "as is" and without warranty of any kind,
** express, implied or otherwise, including without limitation, any
** warranty of merchantability or fitness for a particular purpose.
*/


#ifdef WINDOWS
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#endif
#include <GL/gl.h>

#include "wiregl/include/wireGL.h"
#include "wiregl/include/wiregl_protocol.h"
#include "wiregl/include/wiregl_pipe.h"
#include "wiregl/include/wiregl_util.h"
#include "wiregl/glcontext/glcontext.h"

#include <string.h>

GLcurrent current;

"""

keys = gl_mapping.keys()
keys.sort();

print "static void " + wiregl_common.DecoderName( "BadOpcode" ) + "( void )"
print "{"
print "    wireGLError( \"BadOpcode\" );"
print "}"
print ""

def MakeVector( func_name ):
    return func_name + "v"

def VectorLength( func_name ):
    m = re.search( r"([0-9])", func_name )
    return string.atoi( m.group(1) )

def ReadData( offset, arg_type ):
    if arg_type == "GLdouble" or arg_type == "GLclampd":
	retval = "READ_DOUBLE( " + `offset` + " );"
    else:
	retval = "READ_DATA( " + `offset` + ", " + arg_type + " );"
    return retval

def UpdateCurrentPointer( func_name ):
    m = re.search( r"^(Color|Normal|TexCoord)([1234])(ub|b|us|s|ui|i|f|d)$", func_name )
    if m :
	name = string.lower( m.group(1) )
	type = m.group(3) + m.group(2)
	print "\tcurrent." + name + "." + type + " = unpacker_data_ptr;"
	return

    m = re.match( r"^(Index)(ub|b|us|s|ui|i|f|d)$", func_name )
    if m :
	name = string.lower( m.group(1) )
	type = m.group(2) + "1"
	print "\tcurrent." + name + "." + type + " = unpacker_data_ptr;"
	return

    m = re.match( r"^(EdgeFlag)$", func_name )
    if m :
	name = string.lower( m.group(1) )
	type = "l1"
	print "\tcurrent." + name + "." + type + " = unpacker_data_ptr;"
	return

def MakeNormalCall( return_type, func_name, arg_types, arg_names ):
    counter = 0;
    for i in range( 0, len(arg_names) ):
	if arg_names[i] != '':
	    arg_len = wiregl_common.lengths[arg_types[i]]
	    counter = wiregl_common.FixAlignment( counter, arg_len )
	    print "\t" + arg_types[i] + " " + arg_names[i] + " = ", ReadData( counter, arg_types[i] )
	    counter = counter + arg_len

    if return_type != "void":
	print "\t(void) " + func_name + "( ",
    else:
	print "\t" + func_name + "(",
    print string.join( arg_names, ", " ),
    print ");";

def MakeVectorCall( return_type, func_name, arg_type ):
    if arg_type == "GLdouble" or arg_type == "GLclampd":
	print "#ifdef WIREGL_UNALIGNED_ACCESS_OKAY"
	print "\t" + MakeVector( func_name ) + "( (" + arg_type + " *) unpacker_data_ptr );"
	print "#else"
	num_args = VectorLength( func_name )
	for index in range( 0, num_args ):
	    print "\tGLdouble v" + `index` + " = READ_DOUBLE(", `index * 8`, ");"
	if return_type != "void":
	    print "\t(void) " + func_name + "(",
	else:
	    print "\t" + func_name + "(",
	for index in range( 0, num_args ):
	    print "v" + `index`,
	    if index != num_args - 1:
		print ",",
	    print " ",
	print ");"
	print "#endif"
    else:
	print "\t" + MakeVector( func_name ) + "( (" + arg_type + " *) unpacker_data_ptr );"

for func_name in keys:
    if wiregl_common.FindSpecial( "../opengl_stub/internal_header", func_name ): continue
    if wiregl_common.FindSpecial( "unpacker", func_name ): continue

    ( return_type, arg_names, arg_types ) = gl_mapping[func_name]
    print "void " + wiregl_common.DecoderName( func_name ) + "( void )"
    print "{"

    packet_length = wiregl_common.PacketLength( arg_types )
    if packet_length == -1:
	print '\twireGLSimpleError( "' + func_name + "'s decoder needs to be special cased!\");"
    else:
	if not wiregl_common.FindSpecial( "unpacker_state", func_name ):
	    if not wiregl_common.FindSpecial( "unpacker_vector", func_name ):
		MakeNormalCall( return_type, "gl" + func_name, arg_types, arg_names )
	    else:
		MakeVectorCall( return_type, "gl" + func_name, arg_types[0] )
	else:
	    if wiregl_common.FindSpecial( "unpacker_state", func_name ):
		MakeNormalCall( return_type, "__gltrack_" + func_name, arg_types, arg_names )
	UpdateCurrentPointer ( func_name )
	if packet_length == 0:
	    print "\tINCR_DATA_PTR_NO_ARGS( );"
	else:
	    print "\tINCR_DATA_PTR( " + `packet_length` + " );"
    print "}"
    print ""

for special in wiregl_common.AllSpecials( "unpacker" ):
    print "extern void " + wiregl_common.DecoderName(special) + "( void );"
print ""

print "wiregl_decoder wiregl_decode_functions[] = {"

count = 0
for func_name in keys:
    if wiregl_common.FindSpecial( "../opengl_stub/internal_header", func_name ): continue
    print "\t" + wiregl_common.DecoderName( func_name ) + ","
    count = count + 1

for func_name in ( "SwapBuffers", "BadOpcode", "UpdateClientPointer", "Normal3Compressed", "Vertex3Compressed", "SetVertexCompressionData", "Writeback", "BoundsInfo" ):
    print "\t" + wiregl_common.DecoderName( func_name ) + ","
    count = count + 1

for foo in range(count,255):
    print "\t" + wiregl_common.DecoderName( "BadOpcode" ) + ","

print "\t" + wiregl_common.DecoderName( "BadOpcode" )
print "};"
print ""
