/*
** 3/06/2001
** http://graphics.stanford.edu/software/wiregl
**
** Copyright 2001
** The Board of Trustees of The Leland Stanford Junior University.
** All rights reserved.
**
** Except for commercial resale, lease, license or other commercial
** transactions, permission is hereby given to use, copy, and/or
** modify this software, provided that the above copyright notice and
** this permission notice appear in all copies of this software.  No
** part of this software or any derivatives thereof may be used in
** graphics systems for resale or for use in a commercial product.
**
** This software is provided "as is" and without warranty of any kind,
** express, implied or otherwise, including without limitation, any
** warranty of merchantability or fitness for a particular purpose.
*/

#include "wiregl/include/wiregl_opcodes.h"
#include "wiregl/include/wiregl_pipe.h"
#include "opcode_formats.c"

#ifdef ALIGN
#undef ALIGN
#endif

#define ALIGN(x,y)    (((x) + (y) - 1) & ~(y-1))

#if 0

static const char *begin_modes[] = {
	"GL_POINTS",
	"GL_LINES",
	"GL_LINE_LOOP",
	"GL_LINE_STRIP",
	"GL_TRIANGLES",
	"GL_TRIANGLE_STRIP",
	"GL_TRIANGLE_FAN",
	"GL_QUADS",
	"GL_QUAD_STRIP",
	"GL_POLYGON"
};

#endif

const char *wireGLOpcodeName( WireGLOpcode opcode )
{
	wireGLAssert( opcode < 256 );
	wireGLAssert( opcode_formats[opcode].opcode == opcode );

	return opcode_formats[opcode].name;
}

void wireGLPrintFunc( WireGLOpcode opcode, unsigned char *unpacker_data_ptr )
{
	int i, pos;
	const char *format;

	wireGLAssert( opcode < 256 );
	wireGLAssert( opcode_formats[opcode].opcode == opcode );

	printf( "gl%s( ", opcode_formats[opcode].name );

	pos = 0;
	if (  opcode_formats[opcode].length < 0 )
	{
		printf( "[len=%u], ", READ_DATA( pos, GLuint ) );
		pos += sizeof(GLuint);
	}

	format = opcode_formats[opcode].format;

	for ( i = 0; format[i]; i++ )
	{
		if ( i )
			printf( ", " );

		switch ( format[i] ) {

		  case 'd':
			{
				GLdouble d;
				pos = ALIGN( pos, 4 );
				d = READ_DOUBLE( pos );
				printf( "%f", d );
				pos += 8;
			}
			break;

		  case 'f':
			{
				GLfloat f;
				pos = ALIGN( pos, sizeof(GLfloat) );
				f = READ_DATA( pos, GLfloat );
				printf( "%f", f );
				pos += sizeof(GLfloat);
			}
			break;

		  case 'I':
			{
				GLuint i;
				pos = ALIGN( pos, sizeof(GLuint) );
				i = READ_DATA( pos, GLuint );
				printf( "%u", i );
				pos += sizeof(GLuint);
			}
			break;

		  case 'i':
			{
				GLint i;
				pos = ALIGN( pos, sizeof(GLint) );
				i = READ_DATA( pos, GLint );
				printf( "%d", i );
				pos += sizeof(GLint);
			}
			break;

		  case 'S':
			{
				GLushort i;
				pos = ALIGN( pos, sizeof(GLushort) );
				i = READ_DATA( pos, GLushort );
				printf( "%u", i );
				pos += sizeof(GLushort);
			}
			break;

		  case 's':
			{
				GLshort i;
				pos = ALIGN( pos, sizeof(GLshort) );
				i = READ_DATA( pos, GLshort );
				printf( "%d", i );
				pos += sizeof(GLshort);
			}
			break;

		  case 'B':
			{
				GLubyte i;
				pos = ALIGN( pos, sizeof(GLubyte) );
				i = READ_DATA( pos, GLubyte );
				printf( "%u", i );
				pos += sizeof(GLubyte);
			}
			break;

		  case 'b':
			{
				GLbyte i;
				pos = ALIGN( pos, sizeof(GLbyte) );
				i = READ_DATA( pos, GLbyte );
				printf( "%d", i );
				pos += sizeof(GLbyte);
			}
			break;

		  case 'e':
			{
				GLenum e;
				pos = ALIGN( pos, sizeof(GLenum) );
				e = READ_DATA( pos, GLenum );
				printf( "%d", e );
				pos += sizeof(GLenum);
			}
			break;

		  case 'o':
			{
				GLboolean b;
				pos = ALIGN( pos, sizeof(GLboolean) );
				b = READ_DATA( pos, GLboolean );
				printf( "%d", b );
				pos += sizeof(GLboolean);
			}
			break;

		  case 'u':
			{
				GLsizei u;
				pos = ALIGN( pos, sizeof(GLsizei) );
				u = READ_DATA( pos, GLsizei );
				printf( "%d", u );
				pos += sizeof(GLsizei);
			}
			break;

		  case 'x':
			{
				GLbitfield x;
				pos = ALIGN( pos, sizeof(GLbitfield) );
				x = READ_DATA( pos, GLbitfield );
				printf( "0x%x", x );
				pos += sizeof(GLbitfield);
			}
			break;

		  case 'p':
			{
				GLvoid *x = DATA_POINTER( pos, GLvoid );
				printf( "0x%p", x );
			}
			break;

		  case '!':
			{
				printf( "<special>" );
			}
			break;

		  default:
			wireGLAbort( );
		}
	}
	
	printf( " );\n" );
}
