##
## 3/06/2001
## http://graphics.stanford.edu/software/wiregl
##
## Copyright 2001
## The Board of Trustees of The Leland Stanford Junior University.
## All rights reserved.
##
## Except for commercial resale, lease, license or other commercial
## transactions, permission is hereby given to use, copy, and/or
## modify this software, provided that the above copyright notice and
## this permission notice appear in all copies of this software.  No
## part of this software or any derivatives thereof may be used in
## graphics systems for resale or for use in a commercial product.
##
## This software is provided "as is" and without warranty of any kind,
## express, implied or otherwise, including without limitation, any
## warranty of merchantability or fitness for a particular purpose.
##

import sys;
import cPickle;
import types;
import string;
import re;

import wiregl_common;

parsed_file = open( "../opengl_stub/gl_header.parsed", "rb" )
gl_mapping = cPickle.load( parsed_file )

print "static struct {"
print "    unsigned char opcode;"
print "    const char   *name;"
print "    int           length;"
print "    const char   *format;"
print "} opcode_formats[] = {"

keys = gl_mapping.keys()
keys.sort();

def VectorLength( func_name ):
	m = re.search( r"([0-9])", func_name )
	return string.atoi( m.group(1) )

arg_formats = {}
arg_formats["GLdouble"] = "d"
arg_formats["GLclampd"] = "d"
arg_formats["GLfloat"]  = "f"
arg_formats["GLclampf"] = "f"
arg_formats["GLuint"]   = "I"
arg_formats["GLint"]    = "i"
arg_formats["GLushort"] = "S"
arg_formats["GLshort"]  = "s"
arg_formats["GLubyte"]  = "B"
arg_formats["GLbyte"]   = "b"
arg_formats["GLenum"]   = "e"
arg_formats["GLboolean"] = "o"
arg_formats["GLsizei"]   = "u"
arg_formats["GLbitfield"] = "x"

special_opcodes = {}
special_opcodes["Bitmap"]         = (    -1, "uuffffip" );
special_opcodes["LoadMatrixf"]    = (  16*4, "ffffffffffffffff" );
special_opcodes["MultMatrixf"]    = (  16*4, "ffffffffffffffff" );
special_opcodes["LoadMatrixd"]    = (  16*8, "dddddddddddddddd" );
special_opcodes["MultMatrixd"]    = (  16*8, "dddddddddddddddd" );
special_opcodes["ClipPlane"]      = ( 4+4*8, "edddd" );
special_opcodes["TexImage1D"]     = (    -1, "eiiuieeip" );
special_opcodes["TexSubImage1D"]  = (    -1, "eiiueep" );
special_opcodes["TexImage2D"]     = (    -1, "eiiuuieeip" );
special_opcodes["TexSubImage2D"]  = (    -1, "eiiiuueep" );
special_opcodes["TexParameterfv"] = (    -1, "eep" );
special_opcodes["TexParameteriv"] = (    -1, "eep" );

def MakeNormalCall( func_name, arg_types ):
    format = ""
    for i in range( 0, len(arg_types) ):
	if arg_types[i] != 'void':
	    format = format + arg_formats[arg_types[i]]
    return format

def MakeVectorCall( func_name, arg_type ):
    num_args = VectorLength( func_name )
    format = ""
    for index in range( 0, num_args ):
	format = format + arg_formats[arg_type]
    return format

def Format( func_name, length, format ):
    print "    { " + wiregl_common.OpcodeName(func_name) + ", \"" + func_name + "\", " + `length` + ", \"" + format + "\" },"

count = 0
for func_name in keys:
    if wiregl_common.FindSpecial( "../opengl_stub/internal_header", func_name ):
 	continue
    ( return_type, arg_names, arg_types ) = gl_mapping[func_name]
    packet_length = wiregl_common.PacketLength( arg_types )
    if packet_length == -1:
	try:
	    ( packet_length, format ) = special_opcodes[func_name]
        except KeyError:
	    ( packet_length, format ) = ( -1, "" )
    elif wiregl_common.FindSpecial( "unpacker_vector", func_name ):
	format = MakeVectorCall( func_name, arg_types[0] )
    else:
	format = MakeNormalCall( func_name, arg_types )
    Format( func_name, packet_length, format )
    count = count + 1

Format( "SwapBuffers",               4, ""   );  count = count + 1;
Format( "CreateContext",            -1, ""   );  count = count + 1;
Format( "UpdateClientPointer",      -1, ""   );  count = count + 1;
Format( "Normal3Compressed",        -1, ""   );  count = count + 1;
Format( "Vertex3Compressed",        -1, ""   );  count = count + 1;
Format( "SetVertexCompressionData", -1, ""   );  count = count + 1;
Format( "Writeback",                 4, ""   );  count = count + 1;
Format( "Boundsinfo",               -1, "ffffi" );  count = count + 1;

for index in range(count, 256):
    print "    { " + `index` + ", \"opcode_" + `index` + "\", 0, \"\" },"
print "};"
