/*
** 3/06/2001
** http://graphics.stanford.edu/software/wiregl
**
** Copyright 2001
** The Board of Trustees of The Leland Stanford Junior University.
** All rights reserved.
**
** Except for commercial resale, lease, license or other commercial
** transactions, permission is hereby given to use, copy, and/or
** modify this software, provided that the above copyright notice and
** this permission notice appear in all copies of this software.  No
** part of this software or any derivatives thereof may be used in
** graphics systems for resale or for use in a commercial product.
**
** This software is provided "as is" and without warranty of any kind,
** express, implied or otherwise, including without limitation, any
** warranty of merchantability or fitness for a particular purpose.
*/

#ifdef WINDOWS
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#endif
#include <GL/gl.h>

#include "wiregl/include/wireGL.h"
#include "wiregl/include/wiregl_protocol.h"
#include "wiregl/include/wiregl_pipe.h"
#include "wiregl/include/wiregl_util.h"

#include <stdio.h>

void __decodeMap2d( void  )
{
	GLenum target = READ_DATA( sizeof( int ) + 0, GLenum );
	GLdouble u1 = READ_DOUBLE( sizeof( int ) + 4 );
	GLdouble u2 = READ_DOUBLE( sizeof( int ) + 12 );
	GLint ustride = READ_DATA( sizeof( int ) + 20, GLint );
	GLint uorder = READ_DATA( sizeof( int ) + 24, GLint );
	GLdouble v1 = READ_DOUBLE( sizeof( int ) + 28 );
	GLdouble v2 = READ_DOUBLE( sizeof( int ) + 36 );
	GLint vstride = READ_DATA( sizeof( int ) + 44, GLint );
	GLint vorder = READ_DATA( sizeof( int ) + 48, GLint );

#ifdef WIREGL_UNALIGNED_ACCESS_OKAY
	GLdouble *points = DATA_POINTER( sizeof(int) + 52, GLdouble );

	glMap2d( target, u1, u2, ustride, uorder, v1, v2, vstride, vorder, 
			 points );
#else
	int n_points = READ_DATA( 0, int ) - ( sizeof( int ) + 52 );
	GLdouble *points;

	if ( n_points & 0x7 )
		wireGLError( "__decodeMap2d: n_points=%d, expected multiple of 8\n", n_points );
	points = (GLdouble *) wireGLAlloc( n_points );
	memcpy( points, DATA_POINTER( sizeof(int) + 52, GLdouble ), n_points );

	glMap2d( target, u1, u2, ustride, uorder, v1, v2, vstride, vorder, 
			 points );
	wireGLFree( points );
#endif

	INCR_VAR_PTR();
}

void __decodeMap2f( void  )
{
	GLenum target = READ_DATA( sizeof( int ) + 0, GLenum );
	GLfloat u1 = READ_DATA( sizeof( int ) + 4, GLfloat );
	GLfloat u2 = READ_DATA( sizeof( int ) + 8, GLfloat );
	GLint ustride = READ_DATA( sizeof( int ) + 12, GLint );
	GLint uorder = READ_DATA( sizeof( int ) + 16, GLint );
	GLfloat v1 = READ_DATA( sizeof( int ) + 20, GLfloat );
	GLfloat v2 = READ_DATA( sizeof( int ) + 24, GLfloat );
	GLint vstride = READ_DATA( sizeof( int ) + 28, GLint );
	GLint vorder = READ_DATA( sizeof( int ) + 32, GLint );
	GLfloat *points = DATA_POINTER( sizeof( int ) + 36 , GLfloat );

	glMap2f( target, u1, u2, ustride, uorder, v1, v2, vstride, vorder,
			 points );
	INCR_VAR_PTR();
}

void __decodeMap1d( void  )
{
	GLenum target = READ_DATA( sizeof( int ) + 0, GLenum );
	GLdouble u1 = READ_DOUBLE( sizeof( int ) + 4 );
	GLdouble u2 = READ_DOUBLE( sizeof( int ) + 12 );
	GLint stride = READ_DATA( sizeof( int ) + 20, GLint );
	GLint order = READ_DATA( sizeof( int ) + 24, GLint );

#ifdef WIREGL_UNALIGNED_ACCESS_OKAY
	GLdouble *points = DATA_POINTER( sizeof(int) + 28, GLdouble );
	glMap1d( target, u1, u2, stride, order, points );
#else
	int n_points = READ_DATA( 0, int ) - ( sizeof(int) + 28 );
	GLdouble *points;

	if ( n_points & 0x7 )
		wireGLError( "__decodeMap1d: n_points=%d, expected multiple of 8\n", n_points );
	points = (GLdouble *) wireGLAlloc( n_points );
	memcpy( points, DATA_POINTER( sizeof(int) + 28, GLdouble ), n_points );
	
	glMap1d( target, u1, u2, stride, order, points );
	wireGLFree( points );
#endif

	INCR_VAR_PTR();
}

void __decodeMap1f( void  )
{
	GLenum target = READ_DATA( sizeof( int ) + 0, GLenum );
	GLfloat u1 = READ_DATA( sizeof( int ) + 4, GLfloat );
	GLfloat u2 = READ_DATA( sizeof( int ) + 8, GLfloat );
	GLint stride = READ_DATA( sizeof( int ) + 12, GLint );
	GLint order = READ_DATA( sizeof( int ) + 16, GLint );
	GLfloat *points = DATA_POINTER( sizeof( int ) + 20, GLfloat );

	glMap1f( target, u1, u2, stride, order, points );
	INCR_VAR_PTR();
}
