/*
** 3/06/2001
** http://graphics.stanford.edu/software/wiregl
**
** Copyright 2001
** The Board of Trustees of The Leland Stanford Junior University.
** All rights reserved.
**
** Except for commercial resale, lease, license or other commercial
** transactions, permission is hereby given to use, copy, and/or
** modify this software, provided that the above copyright notice and
** this permission notice appear in all copies of this software.  No
** part of this software or any derivatives thereof may be used in
** graphics systems for resale or for use in a commercial product.
**
** This software is provided "as is" and without warranty of any kind,
** express, implied or otherwise, including without limitation, any
** warranty of merchantability or fitness for a particular purpose.
*/

#include "wiregl/include/wiregl_util.h"

#ifdef WINDOWS
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <GL/gl.h>

#include "wiregl/include/wireGL.h"
#include "wiregl/include/wiregl_protocol.h"
#include "wiregl/include/wiregl_pipe.h"
#include "wiregl/include/wiregl_util.h"

#include "wiregl/opengl_stub/geometry.h"

#define COMPRESS_DATA_SIZE ((sizeof(CompressionDataT) + 3) & ~0x3)

extern unsigned char *unpacker_data_ptr;

static CompressionDataT __wiregl_decode_compressdata={0,0,0,0,0,0,0,0,0};
static FastCompressionDataT __wiregl_decode_fastcompressdata;

static __inline void __calculateFastCompressionData( void )
{
	GLfloat mult[3];
	int bits;

	__wiregl_decode_fastcompressdata.mask[0] = (1 << __wiregl_decode_compressdata.mantissaPrecision[0]) - 1;
	__wiregl_decode_fastcompressdata.mask[1] = (1 << __wiregl_decode_compressdata.mantissaPrecision[1]) - 1;
	__wiregl_decode_fastcompressdata.mask[2] = (1 << __wiregl_decode_compressdata.mantissaPrecision[2]) - 1;

	mult[0] = (GLfloat)__wiregl_decode_fastcompressdata.mask[0];
	mult[1] = (GLfloat)__wiregl_decode_fastcompressdata.mask[1];
	mult[2] = (GLfloat)__wiregl_decode_fastcompressdata.mask[2];

	__wiregl_decode_fastcompressdata.mult[0] = __wiregl_decode_compressdata.scale[0] / mult[0];
	__wiregl_decode_fastcompressdata.mult[1] = __wiregl_decode_compressdata.scale[1] / mult[1];
	__wiregl_decode_fastcompressdata.mult[2] = __wiregl_decode_compressdata.scale[2] / mult[2];

	__wiregl_decode_fastcompressdata.add[0] = __wiregl_decode_compressdata.translate[0];
	__wiregl_decode_fastcompressdata.add[1] = __wiregl_decode_compressdata.translate[1];
	__wiregl_decode_fastcompressdata.add[2] = __wiregl_decode_compressdata.translate[2];

	__wiregl_decode_fastcompressdata.shiftLeft[0] = __wiregl_decode_compressdata.mantissaPrecision[0];
	__wiregl_decode_fastcompressdata.shiftLeft[1] = __wiregl_decode_compressdata.mantissaPrecision[0] + __wiregl_decode_compressdata.mantissaPrecision[1];

	bits = __wiregl_decode_compressdata.mantissaPrecision[0] + __wiregl_decode_compressdata.mantissaPrecision[1] + __wiregl_decode_compressdata.mantissaPrecision[2];
	if(bits > 32)
		__wiregl_decode_fastcompressdata.bitsLeft = 32 - __wiregl_decode_fastcompressdata.shiftLeft[1];
	else
		__wiregl_decode_fastcompressdata.bitsLeft = 0;

	__wiregl_decode_fastcompressdata.bytes = (bits + 7) >> 3;
	__wiregl_decode_fastcompressdata.bytes = ((__wiregl_decode_fastcompressdata.bytes + 3) & ~0x3);
	if(__wiregl_decode_fastcompressdata.bytes == 0)
		__wiregl_decode_fastcompressdata.bytes = 4;
}

void __decodeSetVertexCompressionData( void )
{
	memcpy(&__wiregl_decode_compressdata, unpacker_data_ptr, sizeof(CompressionDataT));
	__calculateFastCompressionData();
	INCR_DATA_PTR(COMPRESS_DATA_SIZE);
}

void __decodeVertex3Compressed( void )
{
	unsigned int *data = (unsigned int *)unpacker_data_ptr;
	GLfloat outData[3];
	unsigned int inData[3];

	inData[0] = *data & __wiregl_decode_fastcompressdata.mask[0];
	inData[1] = (*data >> __wiregl_decode_fastcompressdata.shiftLeft[0]) & __wiregl_decode_fastcompressdata.mask[1];
	inData[2] = (*data >> __wiregl_decode_fastcompressdata.shiftLeft[1]) & __wiregl_decode_fastcompressdata.mask[2];
	if(__wiregl_decode_fastcompressdata.bitsLeft)
		inData[2] |= (*(data + 1) << __wiregl_decode_fastcompressdata.bitsLeft);

	__asm
	{
		fild dword ptr inData[0]
		fld __wiregl_decode_fastcompressdata.mult[0]
		fmul
		fld __wiregl_decode_fastcompressdata.add[0]
		fadd
		fstp dword ptr outData[0]

		fild dword ptr inData[4]
		fld __wiregl_decode_fastcompressdata.mult[4]
		fmul
		fld __wiregl_decode_fastcompressdata.add[4]
		fadd
		fstp dword ptr outData[4]

		fild dword ptr inData[8]
		fld __wiregl_decode_fastcompressdata.mult[8]
		fmul
		fld __wiregl_decode_fastcompressdata.add[8]
		fadd
		fstp dword ptr outData[8]
	}
	
	/*outData[0] = (GLfloat)(inData[0] * __wiregl_decode_fastcompressdata.mult[0] + __wiregl_decode_fastcompressdata.add[0]);
	outData[1] = (GLfloat)(inData[1] * __wiregl_decode_fastcompressdata.mult[1] + __wiregl_decode_fastcompressdata.add[1]);
	outData[2] = (GLfloat)(inData[2] * __wiregl_decode_fastcompressdata.mult[2] + __wiregl_decode_fastcompressdata.add[2]);*/

	glVertex3fv(outData);

	INCR_DATA_PTR(__wiregl_decode_fastcompressdata.bytes);
}

#else

void __decodeSetVertexCompressionData( void )
{
	wireGLSimpleError("SetVertexCompressionData: Only supported on Windows\n");
}

void __decodeVertex3Compressed( void )
{
	wireGLSimpleError("Vertex3Compressed: Only supported on Windows\n");
}

#endif
