/*
** 3/06/2001
** http://graphics.stanford.edu/software/wiregl
**
** Copyright 2001
** The Board of Trustees of The Leland Stanford Junior University.
** All rights reserved.
**
** Except for commercial resale, lease, license or other commercial
** transactions, permission is hereby given to use, copy, and/or
** modify this software, provided that the above copyright notice and
** this permission notice appear in all copies of this software.  No
** part of this software or any derivatives thereof may be used in
** graphics systems for resale or for use in a commercial product.
**
** This software is provided "as is" and without warranty of any kind,
** express, implied or otherwise, including without limitation, any
** warranty of merchantability or fitness for a particular purpose.
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "wiregl/include/wiregl_client.h"
#include "wiregl/include/wiregl_util.h"
#include "wiregl/include/wiregl_const.h"

void OPENGL_APIENTRY
wireGLGetIntegerv( GLuint pname, GLint *params )
{
	if ( pname >= WIREGL_BYTES_PIPE0 && 
		 pname < (GLuint) WIREGL_BYTES_PIPE0 + __wiregl_globals.num_servers )
	{
		int i = pname - WIREGL_BYTES_PIPE0;
		params[0] = __wiregl_globals.servers[i].conn->total_bytes;
		return;
	}

	switch ( pname )
	{
	  case WIREGL_NUM_PIPES:
		params[0] = __wiregl_globals.num_servers;
		break;
	  default:
		wireGLSimpleError( "wireGLGetIntegerv: bad pname=0x%x", pname );
	}
}
