##
## 3/06/2001
## http://graphics.stanford.edu/software/wiregl
##
## Copyright 2001
## The Board of Trustees of The Leland Stanford Junior University.
## All rights reserved.
##
## Except for commercial resale, lease, license or other commercial
## transactions, permission is hereby given to use, copy, and/or
## modify this software, provided that the above copyright notice and
## this permission notice appear in all copies of this software.  No
## part of this software or any derivatives thereof may be used in
## graphics systems for resale or for use in a commercial product.
##
## This software is provided "as is" and without warranty of any kind,
## express, implied or otherwise, including without limitation, any
## warranty of merchantability or fitness for a particular purpose.
##
import string;
import re;

def DecoderName( glName ):
	return "__decode" + glName

def PacketName( glName ):
	return "WireGL" + glName + "Packet"

def OpcodeName( glName ):
	return "WIREGL_" + string.upper( glName ) + "_OPCODE"

def PackFunction( glName ):
	return "WIREGL_PACK_FUNCTION( " + glName + " )"

def PackFunctionMapping():
	return '#define WIREGL_PACK_FUNCTION( x ) __glpack_##x'

def DoPackFunctionMapping( glName ):
	return "__glpack_" + glName

def DoStateFunctionMapping( glName ):
	return "__glstate_" + glName

def DoImmediateMapping( glName ):
	return "__glim_" + glName

specials = {}

def LoadSpecials( filename ):
	table = {}
	try:
		f = open( filename, "r" )
	except:
		specials[filename] = {}
		return {}
	
	for line in f.readlines():
		table[string.strip(line)] = 1
	
	specials[filename] = table
	return table

def FindSpecial( table_file, glName ):
	table = {}
	filename = table_file + "_special"
	try:
		table = specials[filename]
	except KeyError:
		table = LoadSpecials( filename )
	
	try:
		if (table[glName] == 1):
			return 1
		else:
			return 0 #should never happen
	except KeyError:
		return 0

def AllSpecials( table_file ):
	filename = table_file + "_special"

	table = {}
	try:
		table = specials[filename]
	except KeyError:
		table = LoadSpecials(filename)
	
	ret = table.keys()
	ret.sort()
	return ret
	
def NumSpecials( table_file ):
	filename = table_file + "_special"

	table = {}
	try:
		table = specials[filename]
	except KeyError:
		table = LoadSpecials(filename)

	return len(table.keys())

lengths = {}
lengths['GLbyte'] = 1
lengths['GLubyte'] = 1
lengths['GLshort'] = 2
lengths['GLushort'] = 2
lengths['GLint'] = 4
lengths['GLuint'] = 4
lengths['GLfloat'] = 4
lengths['GLclampf'] = 4
lengths['GLdouble'] = 8
lengths['GLclampd'] = 8

lengths['GLenum'] = 4
lengths['GLboolean'] = 1
lengths['GLsizei'] = 4
lengths['GLbitfield'] = 4

lengths['void'] = 0

align_types = 1

def FixAlignment( pos, alignment ):
	# if we want double-alignment take word-alignment instead,
	# yes, this is super-lame, but we know what we are doing
	if alignment > 4:
		alignment = 4
	if align_types and alignment and ( pos % alignment ):
		pos = pos + alignment - ( pos % alignment )
	return pos

def WordAlign( pos ):
	return FixAlignment( pos, 4 )

def PacketLength( arg_types ):
	len = 0
	for arg in arg_types:
		if string.find( arg, '*') != -1:
			return -1;
		temp_arg = re.sub("const ", "", arg)
		size = lengths[temp_arg]
		len = FixAlignment( len, size ) + size
	len = WordAlign( len )
	return len

def ArgumentString( arg_names, arg_types ):
	output = '( '
	for index in range(0,len(arg_names)):
		output = output + arg_types[index]
		if arg_types[index][-1:] != '*' and arg_names[index] != '':
			output = output + " ";
		output = output + arg_names[index]
		if index != len(arg_names) - 1:
			output = output + ", "
	output = output + " )"
	return output
