/*
** 3/06/2001
** http://graphics.stanford.edu/software/wiregl
**
** Copyright 2001
** The Board of Trustees of The Leland Stanford Junior University.
** All rights reserved.
**
** Except for commercial resale, lease, license or other commercial
** transactions, permission is hereby given to use, copy, and/or
** modify this software, provided that the above copyright notice and
** this permission notice appear in all copies of this software.  No
** part of this software or any derivatives thereof may be used in
** graphics systems for resale or for use in a commercial product.
**
** This software is provided "as is" and without warranty of any kind,
** express, implied or otherwise, including without limitation, any
** warranty of merchantability or fitness for a particular purpose.
*/

#include "wiregl/include/wireGL.h"
#include "wiregl/include/wiregl_client.h"
#include "wiregl/include/wiregl_util.h"
#include "wiregl/glcontext/glcontext.h"

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexC2d ) ( GLdouble x, GLdouble y )
{
	unsigned char *data_ptr;
	GET_BUFFERED_COUNT_POINTER( 16 );
	WRITE_DOUBLE( 0, x );
	WRITE_DOUBLE( 8, y );
	WRITE_OPCODE( WIREGL_VERTEX2D_OPCODE );
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexC2dv ) ( const GLdouble *v )
{
	unsigned char *data_ptr;
	GET_BUFFERED_COUNT_POINTER( 16 );
	WRITE_DOUBLE( 0, v[0] );
	WRITE_DOUBLE( 8, v[1] );
	WRITE_OPCODE( WIREGL_VERTEX2D_OPCODE );
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexC2f ) ( GLfloat x, GLfloat y )
{
	unsigned char *data_ptr;
	GET_BUFFERED_COUNT_POINTER( 8 );
	WRITE_DATA( 0, GLfloat, x );
	WRITE_DATA( 4, GLfloat, y );
	WRITE_OPCODE( WIREGL_VERTEX2F_OPCODE );
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexC2fv ) ( const GLfloat *v )
{
	unsigned char *data_ptr;
	GET_BUFFERED_COUNT_POINTER( 8 );
	WRITE_DATA( 0, GLfloat, v[0] );
	WRITE_DATA( 4, GLfloat, v[1] );
	WRITE_OPCODE( WIREGL_VERTEX2F_OPCODE );
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexC2i ) ( GLint x, GLint y )
{
	unsigned char *data_ptr;
	GET_BUFFERED_COUNT_POINTER( 8 );
	WRITE_DATA( 0, GLint, x );
	WRITE_DATA( 4, GLint, y );
	WRITE_OPCODE( WIREGL_VERTEX2I_OPCODE );
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexC2iv ) ( const GLint *v )
{
	unsigned char *data_ptr;
	GET_BUFFERED_COUNT_POINTER( 8 );
	WRITE_DATA( 0, GLint, v[0] );
	WRITE_DATA( 4, GLint, v[1] );
	WRITE_OPCODE( WIREGL_VERTEX2I_OPCODE );
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexC2s ) ( GLshort x, GLshort y )
{
	unsigned char *data_ptr;
	GET_BUFFERED_COUNT_POINTER( 4 );
	WRITE_DATA( 0, GLshort, x );
	WRITE_DATA( 2, GLshort, y );
	WRITE_OPCODE( WIREGL_VERTEX2S_OPCODE );
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexC2sv ) ( const GLshort *v )
{
	unsigned char *data_ptr;
	GET_BUFFERED_COUNT_POINTER( 4 );
	WRITE_DATA( 0, GLshort, v[0] );
	WRITE_DATA( 2, GLshort, v[1] );
	WRITE_OPCODE( WIREGL_VERTEX2S_OPCODE );
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexC3d ) ( GLdouble x, GLdouble y, GLdouble z )
{
	unsigned char *data_ptr;
	GET_BUFFERED_COUNT_POINTER( 24 );
	WRITE_DOUBLE( 0, x );
	WRITE_DOUBLE( 8, y );
	WRITE_DOUBLE( 16, z );
	WRITE_OPCODE( WIREGL_VERTEX3D_OPCODE );
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexC3dv ) ( const GLdouble *v )
{
	unsigned char *data_ptr;
	GET_BUFFERED_COUNT_POINTER( 24 );
	WRITE_DOUBLE( 0, v[0] );
	WRITE_DOUBLE( 8, v[1] );
	WRITE_DOUBLE( 16, v[2] );
	WRITE_OPCODE( WIREGL_VERTEX3D_OPCODE );
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexC3f ) ( GLfloat x, GLfloat y, GLfloat z )
{
	unsigned char *data_ptr;
	GET_BUFFERED_COUNT_POINTER( 12 );
	WRITE_DATA( 0, GLfloat, x );
	WRITE_DATA( 4, GLfloat, y );
	WRITE_DATA( 8, GLfloat, z );
	WRITE_OPCODE( WIREGL_VERTEX3F_OPCODE );
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexC3fv ) ( const GLfloat *v )
{
	unsigned char *data_ptr;
	GET_BUFFERED_COUNT_POINTER( 12 );
	WRITE_DATA( 0, GLfloat, v[0] );
	WRITE_DATA( 4, GLfloat, v[1] );
	WRITE_DATA( 8, GLfloat, v[2] );
	WRITE_OPCODE( WIREGL_VERTEX3F_OPCODE );
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexC3i ) ( GLint x, GLint y, GLint z )
{
	unsigned char *data_ptr;
	GET_BUFFERED_COUNT_POINTER( 12 );
	WRITE_DATA( 0, GLint, x );
	WRITE_DATA( 4, GLint, y );
	WRITE_DATA( 8, GLint, z );
	WRITE_OPCODE( WIREGL_VERTEX3I_OPCODE );
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexC3iv ) ( const GLint *v )
{
	unsigned char *data_ptr;
	GET_BUFFERED_COUNT_POINTER( 12 );
	WRITE_DATA( 0, GLint, v[0] );
	WRITE_DATA( 4, GLint, v[1] );
	WRITE_DATA( 8, GLint, v[2] );
	WRITE_OPCODE( WIREGL_VERTEX3I_OPCODE );
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexC3s ) ( GLshort x, GLshort y, GLshort z )
{
	unsigned char *data_ptr;
	GET_BUFFERED_COUNT_POINTER( 8 );
	WRITE_DATA( 0, GLshort, x );
	WRITE_DATA( 2, GLshort, y );
	WRITE_DATA( 4, GLshort, z );
	WRITE_OPCODE( WIREGL_VERTEX3S_OPCODE );
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexC3sv ) ( const GLshort *v )
{
	unsigned char *data_ptr;
	GET_BUFFERED_COUNT_POINTER( 8 );
	WRITE_DATA( 0, GLshort, v[0] );
	WRITE_DATA( 2, GLshort, v[1] );
	WRITE_DATA( 4, GLshort, v[2] );
	WRITE_OPCODE( WIREGL_VERTEX3S_OPCODE );
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexC4d ) ( GLdouble x, GLdouble y, GLdouble z, GLdouble w )
{
	unsigned char *data_ptr;
	GET_BUFFERED_COUNT_POINTER( 32 );
	WRITE_DOUBLE( 0, x );
	WRITE_DOUBLE( 8, y );
	WRITE_DOUBLE( 16, z );
	WRITE_DOUBLE( 24, w );
	WRITE_OPCODE( WIREGL_VERTEX4D_OPCODE );
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexC4dv ) ( const GLdouble *v )
{
	unsigned char *data_ptr;
	GET_BUFFERED_COUNT_POINTER( 32 );
	WRITE_DOUBLE( 0, v[0] );
	WRITE_DOUBLE( 8, v[1] );
	WRITE_DOUBLE( 16, v[2] );
	WRITE_DOUBLE( 24, v[3] );
	WRITE_OPCODE( WIREGL_VERTEX4D_OPCODE );
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexC4f ) ( GLfloat x, GLfloat y, GLfloat z, GLfloat w )
{
	unsigned char *data_ptr;
	GET_BUFFERED_COUNT_POINTER( 16 );
	WRITE_DATA( 0, GLfloat, x );
	WRITE_DATA( 4, GLfloat, y );
	WRITE_DATA( 8, GLfloat, z );
	WRITE_DATA( 12, GLfloat, w );
	WRITE_OPCODE( WIREGL_VERTEX4F_OPCODE );
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexC4fv ) ( const GLfloat *v )
{
	unsigned char *data_ptr;
	GET_BUFFERED_COUNT_POINTER( 16 );
	WRITE_DATA( 0, GLfloat, v[0] );
	WRITE_DATA( 4, GLfloat, v[1] );
	WRITE_DATA( 8, GLfloat, v[2] );
	WRITE_DATA( 12, GLfloat, v[3] );
	WRITE_OPCODE( WIREGL_VERTEX4F_OPCODE );
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexC4i ) ( GLint x, GLint y, GLint z, GLint w )
{
	unsigned char *data_ptr;
	GET_BUFFERED_COUNT_POINTER( 16 );
	WRITE_DATA( 0, GLint, x );
	WRITE_DATA( 4, GLint, y );
	WRITE_DATA( 8, GLint, z );
	WRITE_DATA( 12, GLint, w );
	WRITE_OPCODE( WIREGL_VERTEX4I_OPCODE );
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexC4iv ) ( const GLint *v )
{
	unsigned char *data_ptr;
	GET_BUFFERED_COUNT_POINTER( 16 );
	WRITE_DATA( 0, GLint, v[0] );
	WRITE_DATA( 4, GLint, v[1] );
	WRITE_DATA( 8, GLint, v[2] );
	WRITE_DATA( 12, GLint, v[3] );
	WRITE_OPCODE( WIREGL_VERTEX4I_OPCODE );
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexC4s ) ( GLshort x, GLshort y, GLshort z, GLshort w )
{
	unsigned char *data_ptr;
	GET_BUFFERED_COUNT_POINTER( 8 );
	WRITE_DATA( 0, GLshort, x );
	WRITE_DATA( 2, GLshort, y );
	WRITE_DATA( 4, GLshort, z );
	WRITE_DATA( 6, GLshort, w );
	WRITE_OPCODE( WIREGL_VERTEX4S_OPCODE );
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( VertexC4sv ) ( const GLshort *v )
{
	unsigned char *data_ptr;
	GET_BUFFERED_COUNT_POINTER( 8 );
	WRITE_DATA( 0, GLshort, v[0] );
	WRITE_DATA( 2, GLshort, v[1] );
	WRITE_DATA( 4, GLshort, v[2] );
	WRITE_DATA( 6, GLshort, v[3] );
	WRITE_OPCODE( WIREGL_VERTEX4S_OPCODE );
}

GLapi vertexCapi[] = {
	{"glVertex2d",  (GLfunc) WIREGL_PACK_FUNCTION( VertexC2d )},
	{"glVertex2dv", (GLfunc) WIREGL_PACK_FUNCTION( VertexC2dv )},
	{"glVertex2f",  (GLfunc) WIREGL_PACK_FUNCTION( VertexC2f )},
	{"glVertex2fv", (GLfunc) WIREGL_PACK_FUNCTION( VertexC2fv )},
	{"glVertex2i",  (GLfunc) WIREGL_PACK_FUNCTION( VertexC2i )},
	{"glVertex2iv", (GLfunc) WIREGL_PACK_FUNCTION( VertexC2iv )},
	{"glVertex2s",  (GLfunc) WIREGL_PACK_FUNCTION( VertexC2s )},
	{"glVertex2sv", (GLfunc) WIREGL_PACK_FUNCTION( VertexC2sv )},
	{"glVertex3d",  (GLfunc) WIREGL_PACK_FUNCTION( VertexC3d )},
	{"glVertex3dv", (GLfunc) WIREGL_PACK_FUNCTION( VertexC3dv )},
	{"glVertex3f",  (GLfunc) WIREGL_PACK_FUNCTION( VertexC3f )},
	{"glVertex3fv", (GLfunc) WIREGL_PACK_FUNCTION( VertexC3fv )},
	{"glVertex3i",  (GLfunc) WIREGL_PACK_FUNCTION( VertexC3i )},
	{"glVertex3iv", (GLfunc) WIREGL_PACK_FUNCTION( VertexC3iv )},
	{"glVertex3s",  (GLfunc) WIREGL_PACK_FUNCTION( VertexC3s )},
	{"glVertex3sv", (GLfunc) WIREGL_PACK_FUNCTION( VertexC3sv )},
	{"glVertex4d",  (GLfunc) WIREGL_PACK_FUNCTION( VertexC4d )},
	{"glVertex4dv", (GLfunc) WIREGL_PACK_FUNCTION( VertexC4dv )},
	{"glVertex4f",  (GLfunc) WIREGL_PACK_FUNCTION( VertexC4f )},
	{"glVertex4fv", (GLfunc) WIREGL_PACK_FUNCTION( VertexC4fv )},
	{"glVertex4i",  (GLfunc) WIREGL_PACK_FUNCTION( VertexC4i )},
	{"glVertex4iv", (GLfunc) WIREGL_PACK_FUNCTION( VertexC4iv )},
	{"glVertex4s",  (GLfunc) WIREGL_PACK_FUNCTION( VertexC4s )},
	{"glVertex4sv", (GLfunc) WIREGL_PACK_FUNCTION( VertexC4sv )},
	{NULL, NULL}};

