/*
** 3/06/2001
** http://graphics.stanford.edu/software/wiregl
**
** Copyright 2001
** The Board of Trustees of The Leland Stanford Junior University.
** All rights reserved.
**
** Except for commercial resale, lease, license or other commercial
** transactions, permission is hereby given to use, copy, and/or
** modify this software, provided that the above copyright notice and
** this permission notice appear in all copies of this software.  No
** part of this software or any derivatives thereof may be used in
** graphics systems for resale or for use in a commercial product.
**
** This software is provided "as is" and without warranty of any kind,
** express, implied or otherwise, including without limitation, any
** warranty of merchantability or fitness for a particular purpose.
*/

#include <string.h>
#include "wiregl/include/wireGL.h"
#include "wiregl/include/wiregl_protocol.h"
#include "wiregl/include/wiregl_client.h"
#include "wiregl/glcontext/glcontext.h"

static unsigned char * __gl_HandlePixelMapData( GLenum map, GLsizei mapsize, int size_of_value, const GLvoid *values )
{
	int packet_length = 
		sizeof( map ) + 
		sizeof( mapsize ) + 
		mapsize*size_of_value;
	unsigned char *data_ptr = (unsigned char *) wireGLAllocPacket( packet_length );

	WRITE_DATA( 0, GLenum, map );
	WRITE_DATA( 4, GLsizei, mapsize );
	memcpy( data_ptr + 8, values, mapsize*size_of_value );
	return data_ptr;
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( PixelMapfv  )(GLenum map, GLsizei mapsize, 
		const GLfloat *values )
{
	unsigned char *data_ptr = __gl_HandlePixelMapData( map, mapsize, sizeof( *values ), values );

	wireGLSendPacket( WIREGL_PIXELMAPFV_OPCODE, data_ptr );
	wireGLFreePacket( data_ptr );
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( PixelMapuiv  )(GLenum map, GLsizei mapsize, 
		const GLuint *values )
{
	unsigned char *data_ptr = __gl_HandlePixelMapData( map, mapsize, sizeof( *values ), values );

	wireGLSendPacket( WIREGL_PIXELMAPUIV_OPCODE, data_ptr );
	wireGLFreePacket( data_ptr );
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( PixelMapusv  )(GLenum map, GLsizei mapsize, 
		const GLushort *values )
{
	unsigned char *data_ptr = __gl_HandlePixelMapData( map, mapsize, sizeof( *values ), values );

	wireGLSendPacket( WIREGL_PIXELMAPUSV_OPCODE, data_ptr );
	wireGLFreePacket( data_ptr );
}
