#!/usr/common/bin/python
##
## 3/06/2001
## http://graphics.stanford.edu/software/wiregl
##
## Copyright 2001
## The Board of Trustees of The Leland Stanford Junior University.
## All rights reserved.
##
## Except for commercial resale, lease, license or other commercial
## transactions, permission is hereby given to use, copy, and/or
## modify this software, provided that the above copyright notice and
## this permission notice appear in all copies of this software.  No
## part of this software or any derivatives thereof may be used in
## graphics systems for resale or for use in a commercial product.
##
## This software is provided "as is" and without warranty of any kind,
## express, implied or otherwise, including without limitation, any
## warranty of merchantability or fitness for a particular purpose.
##

import sys;
import re;
import string;
import cPickle;

func_line = '^WINGDIAPI'
line_reg_exp = re.compile(func_line)

system_gl = open("system_gl_header/GL.H", 'r')
output_mapping_file = open("gl_header.parsed", 'wb')
output_mapping = {}

for line in system_gl.readlines():
	match = line_reg_exp.match( line )
	if match != None:
		line = re.sub( "WINGDIAPI ", "", line )
		return_end = string.find( line, " APIENTRY" )
		return_type = line[:return_end]

		func_start = string.find( line, "gl" );
		func_end = string.find( line, " (", func_start )

		func_name = line[func_start+2:func_end] # strip off the "gl"

		args_start = func_end + 2
		args_end = string.find( line, ")", args_start )

		args = string.split( line[args_start:args_end], "," )
		arg_types = [];
		arg_names = [];
		for arg in args:
			arg_name_start = string.rfind( arg, "*" );
			if arg_name_start == -1:
				arg_name_start = string.rfind( arg, " ");
				if arg_name_start == -1:
					arg_name_start = len(arg)
			arg_names = arg_names + [string.strip(arg[arg_name_start+1:])]
			arg_types = arg_types + [string.strip(arg[:arg_name_start+1])]

		output_mapping[func_name] = ( return_type, arg_names, arg_types )

cPickle.dump( output_mapping, output_mapping_file, 1 )
