/*
** 3/06/2001
** http://graphics.stanford.edu/software/wiregl
**
** Copyright 2001
** The Board of Trustees of The Leland Stanford Junior University.
** All rights reserved.
**
** Except for commercial resale, lease, license or other commercial
** transactions, permission is hereby given to use, copy, and/or
** modify this software, provided that the above copyright notice and
** this permission notice appear in all copies of this software.  No
** part of this software or any derivatives thereof may be used in
** graphics systems for resale or for use in a commercial product.
**
** This software is provided "as is" and without warranty of any kind,
** express, implied or otherwise, including without limitation, any
** warranty of merchantability or fitness for a particular purpose.
*/

#include "wiregl/include/wireGL.h"
#include "wiregl/include/wiregl_protocol.h"
#include "wiregl/include/wiregl_client.h"

void OPENGL_APIENTRY 
WIREGL_PACK_FUNCTION( BarrierCreate )( GLuint name, GLuint count )
{
	GLuint args[2];

	args[0] = name;
	args[1] = count;

	wireGLFlushAllWithOpcode( __wiregl_globals.context,
							  WIREGL_BARRIERCREATE_OPCODE,
							  sizeof(args), args );
}

void OPENGL_APIENTRY 
WIREGL_PACK_FUNCTION( BarrierDestroy )( GLuint name )
{
	GLuint args[1];

	args[0] = name;

	wireGLFlushAllWithOpcode( __wiregl_globals.context,
							  WIREGL_BARRIERDESTROY_OPCODE,
							  sizeof(args), args );
}

void OPENGL_APIENTRY 
WIREGL_PACK_FUNCTION( BarrierExec )( GLuint name )
{
	GLuint args[1];

	args[0] = name;

	wireGLFlushAllWithOpcode( __wiregl_globals.context,
							  WIREGL_BARRIEREXEC_OPCODE,
							  sizeof(args), args );
}

void OPENGL_APIENTRY 
WIREGL_PACK_FUNCTION( SemaphoreCreate )( GLuint name, GLuint count )
{
	GLuint args[2];

	args[0] = name;
	args[1] = count;

	wireGLFlushAllWithOpcode( __wiregl_globals.context,
							  WIREGL_SEMAPHORECREATE_OPCODE,
							  sizeof(args), args );
}

void OPENGL_APIENTRY 
WIREGL_PACK_FUNCTION( SemaphoreDestroy )( GLuint name )
{
	GLuint args[1];

	args[0] = name;

	wireGLFlushAllWithOpcode( __wiregl_globals.context,
							  WIREGL_SEMAPHOREDESTROY_OPCODE,
							  sizeof(args), args );
}

void OPENGL_APIENTRY 
WIREGL_PACK_FUNCTION( SemaphoreP )( GLuint name )
{
	GLuint args[1];

	args[0] = name;

	wireGLFlushAllWithOpcode( __wiregl_globals.context,
							  WIREGL_SEMAPHOREP_OPCODE,
							  sizeof(args), args );
}

void OPENGL_APIENTRY
WIREGL_PACK_FUNCTION( SemaphoreV )( GLuint name )
{
	GLuint args[1];

	args[0] = name;

	wireGLFlushAllWithOpcode( __wiregl_globals.context,
							  WIREGL_SEMAPHOREV_OPCODE,
							  sizeof(args), args );
}
