##
## 3/06/2001
## http://graphics.stanford.edu/software/wiregl
##
## Copyright 2001
## The Board of Trustees of The Leland Stanford Junior University.
## All rights reserved.
##
## Except for commercial resale, lease, license or other commercial
## transactions, permission is hereby given to use, copy, and/or
## modify this software, provided that the above copyright notice and
## this permission notice appear in all copies of this software.  No
## part of this software or any derivatives thereof may be used in
## graphics systems for resale or for use in a commercial product.
##
## This software is provided "as is" and without warranty of any kind,
## express, implied or otherwise, including without limitation, any
## warranty of merchantability or fitness for a particular purpose.
##

import sys;
import cPickle;
import types;
import string;
import re;

import wiregl_common;

parsed_file = open( "gl_header.parsed", "rb" )
gl_mapping = cPickle.load( parsed_file )

print "/* opengl_stub/opengl.c */"
print """

/*
** 3/06/2001
** http://graphics.stanford.edu/software/wiregl
**
** Copyright 2001
** The Board of Trustees of The Leland Stanford Junior University.
** All rights reserved.
**
** Except for commercial resale, lease, license or other commercial
** transactions, permission is hereby given to use, copy, and/or
** modify this software, provided that the above copyright notice and
** this permission notice appear in all copies of this software.  No
** part of this software or any derivatives thereof may be used in
** graphics systems for resale or for use in a commercial product.
**
** This software is provided "as is" and without warranty of any kind,
** express, implied or otherwise, including without limitation, any
** warranty of merchantability or fitness for a particular purpose.
*/


#include "wiregl/include/wireGL.h"
#include "wiregl/include/wiregl_protocol.h"
#include "wiregl/include/wiregl_client.h"
#include "wiregl/include/wiregl_util.h"
#include "wiregl/glcontext/glcontext.h"

char *__wiregl_opcode_names[] = {
"""

keys = gl_mapping.keys()
keys.sort()

for func_name in keys:
    if (wiregl_common.FindSpecial( "internal_header", func_name ) ): continue
    print '    "' + func_name + '",'

print '    "SwapBuffers",'
print '    "CreateContext",'
print '    "UpdateClientPointer",'
print '    "Normal3Compressed",'
print '    "Vertex3Compressed",'
print '    "SetVertexCompressionData",'
print '    "Writeback",'
print '    "BoundsInfo",'
print '    "NOP"'
print "};"
print ""

def SmackVector( func_name ):
    return re.sub( "v$", "", func_name )

def VectorLength( func_name ):
    m = re.search( r"([0-9])", func_name )
    return string.atoi( m.group(1) )

def WriteData( offset, arg_type, arg_name ):
    if arg_type == "GLdouble" or arg_type == "GLclampd":
	retval = "\tWRITE_DOUBLE( " + `offset` + ", " + arg_name + " );"
    else:	
	retval = "\tWRITE_DATA( " + `offset` + ", " + arg_type + ", " + arg_name + " );"
    return retval

def UpdateCurrentPointer( func_name ):
    m = re.search( r"^(Color|Normal|TexCoord)([1234])(ub|b|us|s|ui|i|f|d)$", func_name )
    if m :
	name = string.lower( m.group(1) )
	type = m.group(3) + m.group(2)
	print "\t__wiregl_globals.current." + name + "." + type + " = data_ptr;"
	return

    m = re.match( r"^(Index)(ub|b|us|s|ui|i|f|d)$", func_name )
    if m :
	name = string.lower( m.group(1) )
	type = m.group(2) + "1"
	print "\t__wiregl_globals.current." + name + "." + type + " = data_ptr;"
	return

    m = re.match( r"^(EdgeFlag)$", func_name )
    if m :
	name = string.lower( m.group(1) )
	type = "l1"
	print "\t__wiregl_globals.current." + name + "." + type + " = data_ptr;"
	return

    m = re.match( r"^(Begin)$", func_name )
    if m :
	name = string.lower( m.group(1) )
	type = ""
	print "\t__wiregl_globals.current." + name + "_data = data_ptr;"
	print "\t__wiregl_globals.current." + name + "_op = __wiregl_globals.buffer.opcode_current;"
	return

def IsVector ( func_name ) :
    m = re.search( r"^(Color|EdgeFlag|EvalCoord|Index|Normal|TexCoord|Vertex)([1234]?)(ub|b|us|s|ui|i|f|d|)v$", func_name )
    if m :
	if m.group(2) :
	    return string.atoi( m.group(2) )
	else:
	    return 1
    else:
	return 0

for func_name in keys:
    ( return_type, arg_names, arg_types ) = gl_mapping[func_name]

    if ( wiregl_common.FindSpecial( "packer", func_name ) ): continue
    print return_type + ' OPENGL_APIENTRY ' + wiregl_common.PackFunction( func_name ),
    print wiregl_common.ArgumentString( arg_names, arg_types )
    print '{'
    orig_func_name = func_name[:] #make copy
    vector_arg_type = ""
    vector_nelem = IsVector( func_name )
    if vector_nelem :
	func_name = SmackVector( func_name )
	vector_arg_type = re.sub( r"\*", "", arg_types[0] )
	vector_arg_type = re.sub( "const ", "", vector_arg_type )
	vector_arg_type = string.strip( vector_arg_type )
	packet_length = wiregl_common.WordAlign( vector_nelem * wiregl_common.lengths[vector_arg_type] )
    else:
	packet_length = wiregl_common.PacketLength( arg_types )

    if packet_length == -1:
	print '\twireGLSimpleError( "' + orig_func_name + ' needs to be special cased!");'
	for arg in arg_names:
	    print "\tWIREGL_UNUSED(" + arg + ");"
    else:
	print "\tunsigned char *data_ptr;"
	if packet_length == 0:
	    print "\tGET_BUFFERED_POINTER_NO_ARGS( );"
	else:
	    print "\tGET_BUFFERED_POINTER(", packet_length, ");"

	UpdateCurrentPointer( func_name )
		
	counter = 0
	if vector_nelem :
	    for index in range( 0, vector_nelem ):
		print WriteData( index*wiregl_common.lengths[vector_arg_type], vector_arg_type, arg_names[-1] + "[" + `index` + "]" )
	else:
	    for index in range(0,len(arg_names)):
		if arg_names[index] != '':
		    print WriteData( counter, arg_types[index], arg_names[index] )
		    counter = counter + wiregl_common.lengths[arg_types[index]]
	print "\tWRITE_OPCODE( " + wiregl_common.OpcodeName( func_name ) + " );"
    if return_type != "void":
	print "\treturn (" + return_type + ") 0; /* THIS IS BAD */" 
    print '}\n'












