/*
** 3/06/2001
** http://graphics.stanford.edu/software/wiregl
**
** Copyright 2001
** The Board of Trustees of The Leland Stanford Junior University.
** All rights reserved.
**
** Except for commercial resale, lease, license or other commercial
** transactions, permission is hereby given to use, copy, and/or
** modify this software, provided that the above copyright notice and
** this permission notice appear in all copies of this software.  No
** part of this software or any derivatives thereof may be used in
** graphics systems for resale or for use in a commercial product.
**
** This software is provided "as is" and without warranty of any kind,
** express, implied or otherwise, including without limitation, any
** warranty of merchantability or fitness for a particular purpose.
*/

#include "wiregl/include/wireGL.h"
#include "wiregl/include/wiregl_protocol.h"
#include "wiregl/include/wiregl_client.h"

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( MultMatrixd  )( const GLdouble *m )
{
	unsigned char *data_ptr;
	int packet_length = 16*sizeof( *m );
	GET_BUFFERED_POINTER( packet_length );
	WRITE_DOUBLE( 0*sizeof(double), m[ 0] );
	WRITE_DOUBLE( 1*sizeof(double), m[ 1] );
	WRITE_DOUBLE( 2*sizeof(double), m[ 2] );
	WRITE_DOUBLE( 3*sizeof(double), m[ 3] );
	WRITE_DOUBLE( 4*sizeof(double), m[ 4] );
	WRITE_DOUBLE( 5*sizeof(double), m[ 5] );
	WRITE_DOUBLE( 6*sizeof(double), m[ 6] );
	WRITE_DOUBLE( 7*sizeof(double), m[ 7] );
	WRITE_DOUBLE( 8*sizeof(double), m[ 8] );
	WRITE_DOUBLE( 9*sizeof(double), m[ 9] );
	WRITE_DOUBLE( 10*sizeof(double), m[10] );
	WRITE_DOUBLE( 11*sizeof(double), m[11] );
	WRITE_DOUBLE( 12*sizeof(double), m[12] );
	WRITE_DOUBLE( 13*sizeof(double), m[13] );
	WRITE_DOUBLE( 14*sizeof(double), m[14] );
	WRITE_DOUBLE( 15*sizeof(double), m[15] );
	WRITE_OPCODE( WIREGL_MULTMATRIXD_OPCODE );
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( MultMatrixf  )( const GLfloat *m )
{
	unsigned char *data_ptr;
	int packet_length = 16*sizeof( *m );
	GET_BUFFERED_POINTER( packet_length ); 
	WRITE_DATA( 0*sizeof(float), float, m[ 0] );
	WRITE_DATA( 1*sizeof(float), float, m[ 1] );
	WRITE_DATA( 2*sizeof(float), float, m[ 2] );
	WRITE_DATA( 3*sizeof(float), float, m[ 3] );
	WRITE_DATA( 4*sizeof(float), float, m[ 4] );
	WRITE_DATA( 5*sizeof(float), float, m[ 5] );
	WRITE_DATA( 6*sizeof(float), float, m[ 6] );
	WRITE_DATA( 7*sizeof(float), float, m[ 7] );
	WRITE_DATA( 8*sizeof(float), float, m[ 8] );
	WRITE_DATA( 9*sizeof(float), float, m[ 9] );
	WRITE_DATA( 10*sizeof(float), float, m[10] );
	WRITE_DATA( 11*sizeof(float), float, m[11] );
	WRITE_DATA( 12*sizeof(float), float, m[12] );
	WRITE_DATA( 13*sizeof(float), float, m[13] );
	WRITE_DATA( 14*sizeof(float), float, m[14] );
	WRITE_DATA( 15*sizeof(float), float, m[15] );
	WRITE_OPCODE( WIREGL_MULTMATRIXF_OPCODE );
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( LoadMatrixd  )( const GLdouble *m )
{
	unsigned char *data_ptr;
	int packet_length = 16*sizeof( *m );
	GET_BUFFERED_POINTER( packet_length );
	WRITE_DOUBLE( 0*sizeof(double), m[ 0] );
	WRITE_DOUBLE( 1*sizeof(double), m[ 1] );
	WRITE_DOUBLE( 2*sizeof(double), m[ 2] );
	WRITE_DOUBLE( 3*sizeof(double), m[ 3] );
	WRITE_DOUBLE( 4*sizeof(double), m[ 4] );
	WRITE_DOUBLE( 5*sizeof(double), m[ 5] );
	WRITE_DOUBLE( 6*sizeof(double), m[ 6] );
	WRITE_DOUBLE( 7*sizeof(double), m[ 7] );
	WRITE_DOUBLE( 8*sizeof(double), m[ 8] );
	WRITE_DOUBLE( 9*sizeof(double), m[ 9] );
	WRITE_DOUBLE( 10*sizeof(double), m[10] );
	WRITE_DOUBLE( 11*sizeof(double), m[11] );
	WRITE_DOUBLE( 12*sizeof(double), m[12] );
	WRITE_DOUBLE( 13*sizeof(double), m[13] );
	WRITE_DOUBLE( 14*sizeof(double), m[14] );
	WRITE_DOUBLE( 15*sizeof(double), m[15] );
	WRITE_OPCODE( WIREGL_LOADMATRIXD_OPCODE );
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( LoadMatrixf  )( const GLfloat *m )
{
	unsigned char *data_ptr;
	int packet_length = 16*sizeof( *m );
	GET_BUFFERED_POINTER( packet_length );
	WRITE_DATA( 0*sizeof(float), float, m[ 0] );
	WRITE_DATA( 1*sizeof(float), float, m[ 1] );
	WRITE_DATA( 2*sizeof(float), float, m[ 2] );
	WRITE_DATA( 3*sizeof(float), float, m[ 3] );
	WRITE_DATA( 4*sizeof(float), float, m[ 4] );
	WRITE_DATA( 5*sizeof(float), float, m[ 5] );
	WRITE_DATA( 6*sizeof(float), float, m[ 6] );
	WRITE_DATA( 7*sizeof(float), float, m[ 7] );
	WRITE_DATA( 8*sizeof(float), float, m[ 8] );
	WRITE_DATA( 9*sizeof(float), float, m[ 9] );
	WRITE_DATA( 10*sizeof(float), float, m[10] );
	WRITE_DATA( 11*sizeof(float), float, m[11] );
	WRITE_DATA( 12*sizeof(float), float, m[12] );
	WRITE_DATA( 13*sizeof(float), float, m[13] );
	WRITE_DATA( 14*sizeof(float), float, m[14] );
	WRITE_DATA( 15*sizeof(float), float, m[15] );
	WRITE_OPCODE( WIREGL_LOADMATRIXF_OPCODE );
}
