/*
** 3/06/2001
** http://graphics.stanford.edu/software/wiregl
**
** Copyright 2001
** The Board of Trustees of The Leland Stanford Junior University.
** All rights reserved.
**
** Except for commercial resale, lease, license or other commercial
** transactions, permission is hereby given to use, copy, and/or
** modify this software, provided that the above copyright notice and
** this permission notice appear in all copies of this software.  No
** part of this software or any derivatives thereof may be used in
** graphics systems for resale or for use in a commercial product.
**
** This software is provided "as is" and without warranty of any kind,
** express, implied or otherwise, including without limitation, any
** warranty of merchantability or fitness for a particular purpose.
*/

#include "wiregl/include/wireGL.h"
#include "wiregl/include/wiregl_protocol.h"
#include "wiregl/include/wiregl_client.h"

static void __handleMaterialData( GLenum face, GLenum pname, const GLfloat *params )
{
	unsigned int packet_length = sizeof( int ) + sizeof( face ) + sizeof( pname );
	unsigned int params_length = 0;
	unsigned char *data_ptr;
	switch( pname )
	{
		case GL_AMBIENT:
		case GL_DIFFUSE:
		case GL_SPECULAR:
		case GL_EMISSION:
		case GL_AMBIENT_AND_DIFFUSE:
			params_length = 4*sizeof( *params );
			break;
		case GL_COLOR_INDEXES:
			params_length = 3*sizeof( *params );
			break;
		case GL_SHININESS:
			params_length = sizeof( *params );
			break;
		default:
			wireGLSimpleError( "Unknown Parameter: %d", pname );
	}
	packet_length += params_length;

	GET_BUFFERED_POINTER( packet_length );
	WRITE_DATA( 0, int, packet_length );
	WRITE_DATA( sizeof( int ) + 0, GLenum, face );
	WRITE_DATA( sizeof( int ) + 4, GLenum, pname );
	WRITE_DATA( sizeof( int ) + 8, GLfloat, params[0] );
	if (params_length > sizeof( *params )) 
	{
		WRITE_DATA( sizeof( int ) + 12, GLfloat, params[1] );
		WRITE_DATA( sizeof( int ) + 16, GLfloat, params[2] );
	}
	if (packet_length > 3*sizeof( *params ) ) WRITE_DATA( sizeof( int ) + 20, GLfloat, params[3] );
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( Materialfv  )(GLenum face, GLenum pname, const GLfloat *params)
{
	__handleMaterialData( face, pname, params );
	WRITE_OPCODE( WIREGL_MATERIALFV_OPCODE );
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( Materialiv  )(GLenum face, GLenum pname, const GLint *params)
{
	/* floats and ints are the same size, so the packing should be the same */
	__handleMaterialData( face, pname, (const GLfloat *) params );
	WRITE_OPCODE( WIREGL_MATERIALIV_OPCODE );
}
