##
## 3/06/2001
## http://graphics.stanford.edu/software/wiregl
##
## Copyright 2001
## The Board of Trustees of The Leland Stanford Junior University.
## All rights reserved.
##
## Except for commercial resale, lease, license or other commercial
## transactions, permission is hereby given to use, copy, and/or
## modify this software, provided that the above copyright notice and
## this permission notice appear in all copies of this software.  No
## part of this software or any derivatives thereof may be used in
## graphics systems for resale or for use in a commercial product.
##
## This software is provided "as is" and without warranty of any kind,
## express, implied or otherwise, including without limitation, any
## warranty of merchantability or fitness for a particular purpose.
##

import cPickle;
import wiregl_common;

parsed_file = None
pipeserver = None

ih_special = "internal_header"
try:
	parsed_file = open( "gl_header.parsed", "rb" )
except:
	parsed_file = open( "../opengl_stub/gl_header.parsed", "rb" )
	ih_special = "../opengl_stub/internal_header"

gl_mapping = cPickle.load( parsed_file )

keys = gl_mapping.keys()
keys.sort();

print """

/*
** 3/06/2001
** http://graphics.stanford.edu/software/wiregl
**
** Copyright 2001
** The Board of Trustees of The Leland Stanford Junior University.
** All rights reserved.
**
** Except for commercial resale, lease, license or other commercial
** transactions, permission is hereby given to use, copy, and/or
** modify this software, provided that the above copyright notice and
** this permission notice appear in all copies of this software.  No
** part of this software or any derivatives thereof may be used in
** graphics systems for resale or for use in a commercial product.
**
** This software is provided "as is" and without warranty of any kind,
** express, implied or otherwise, including without limitation, any
** warranty of merchantability or fitness for a particular purpose.
*/


static const int __wiregl_packet_length_table[] = {
"""
for func_name in keys:
    if wiregl_common.FindSpecial( ih_special, func_name ): continue
    (return_type, arg_names, arg_types ) = gl_mapping[func_name]
    print "\t" + `wiregl_common.PacketLength( arg_types )` + ", /* " +  func_name + " */"

print "\t0,  /* SwapBuffers */"
print "\t-1, /* CreateContext */"
print "\t-1, /* UpdateClientPointer */"
print "\t2,  /* Normal3Compressed */"
print "\t-2, /* Vertex3Compressed -> Length is special-case handled */"
print "\t27, /* SetGeometryCompressionData */"
print "\t0,  /* NOP */"
print "};"
