/*
** 3/06/2001
** http://graphics.stanford.edu/software/wiregl
**
** Copyright 2001
** The Board of Trustees of The Leland Stanford Junior University.
** All rights reserved.
**
** Except for commercial resale, lease, license or other commercial
** transactions, permission is hereby given to use, copy, and/or
** modify this software, provided that the above copyright notice and
** this permission notice appear in all copies of this software.  No
** part of this software or any derivatives thereof may be used in
** graphics systems for resale or for use in a commercial product.
**
** This software is provided "as is" and without warranty of any kind,
** express, implied or otherwise, including without limitation, any
** warranty of merchantability or fitness for a particular purpose.
*/

#include <stdlib.h>

#include "wiregl/include/wiregl_util.h"
#include "wiregl/include/wiregl_client.h"
#include "wiregl/include/wiregl_protocol.h"
#include "wiregl/include/wiregl_common.h"

#include "wiregl/include/wiregl_instrument.h"

#include "wiregl/opengl_stub/geometry.h"

#include "wiregl/glcontext/glconfig.h"
#include "wiregl/glcontext/glcontext.h"

extern GLapi wiregl_compresspack_api[];

void 
wireGLPrintExitStatistics( void )
{
	int i;

	if ( __wiregl_globals.print.bytes_per_server )
	{
		wireGLInstrumentPrintPerServerCounter( WIREGL_BYTES_PER_SERVER );
	}
	if ( __wiregl_globals.print.bytes_per_frame_per_server )
	{
		for (i = 0 ; i < __wiregl_globals.num_servers ; i++)
		{
			wireGLInstrumentPrintPerFrameCounter( WIREGL_BYTES_PER_SERVER_PER_FRAME + i );
		}
	}
	if ( __wiregl_globals.print.min_bytes_sent )
	{
		wireGLInstrumentPrintCounter( WIREGL_MIN_BYTES_SENT );
	}
	if ( __wiregl_globals.print.frame_rate )
	{
		wireGLInstrumentPrintPerFrameCounter( WIREGL_FRAME_TIMER );
	}
	if ( __wiregl_globals.print.flush_time )
	{
		wireGLInstrumentPrintPerFrameCounter( WIREGL_FLUSH_TIMER );
	}
	if ( __wiregl_globals.print.send_time )
	{
		wireGLInstrumentPrintPerFrameCounter( WIREGL_SEND_TIMER );
	}
	if ( __wiregl_globals.print.diff_context_time )
	{
		wireGLInstrumentPrintPerFrameCounter( WIREGL_DIFF_CONTEXT_TIMER );
	}
	if ( __wiregl_globals.print.total_bytes_sent )
	{
		wireGLInstrumentPrintCounter( WIREGL_TOTAL_BYTES_SENT );
	}
	if ( __wiregl_globals.print.total_time )
	{
		wireGLInstrumentPrintTimer( WIREGL_TOTAL_TIME );
	}
	wireGLInstrumentShutDown();
}

/* hack */
static int hack_is_parallel = 0;
static int init_L2 = 0;

void
wireGLSyncWithL2( void ) 
{
	int i;

	if ( __glGetCurrentContext( ) == NULL )
	{
		wireGLError( "wireGLSyncWithL2: no current context" );
	}

	if ( __wiregl_globals.sync_L2 )
	{
		wireGLWarning( WIREGL_WARN_DEBUG, "wireGLSyncWithL2: start" );
		__glstate_SetBroadcast( GL_TRUE );

		for ( i = 0; i <= 4; i++ )
		{
			wireGLWarning( WIREGL_WARN_DEBUG, "wireGLSyncWithL2: phase=%u",
						   i );
			__glpack_SyncL2( i );
			wireGLSyncWithPipes( );
		}

		__glstate_SetBroadcast( __wiregl_globals.broadcast );
		wireGLWarning( WIREGL_WARN_DEBUG, "wireGLSyncWithL2: done" );
	}

	init_L2 = 1;
}

/* XXX HACK: Which header file does this go in? */
extern void __glpack_UpdateClientPointer (int array, int index_size, int *index, int data_size, unsigned char * data);
extern GLcurrent current;

void OPENGL_APIENTRY
wireGLMakeCurrent( void )
{
	__glMakeCurrent( __wiregl_globals.context );
	if ( !hack_is_parallel && !init_L2 )
	{
		wireGLSyncWithL2( );
	}
}

void OPENGL_APIENTRY
wireGLCreateContext( int is_parallel )
{
	static int first_call = 1;

	WireGLGlobals *g = &__wiregl_globals;
	int i, j;
	GLconfig *c;

	if ( !first_call )
	{
		wireGLSimpleError( "wireGLCreateContext: called more than once!\n" );
	}
	first_call = 0;

	wireGLInitOS( );
	wireGLInitInstrumentation( TO_SCREEN );
	wireGLInitGlobals( );

	atexit( wireGLPrintExitStatistics );

	/* surprise, when we come back from ClientParseConfig() we've also
       connected to the servers!  Wheee! */
	wireGLClientParseConfig( );

	wireGLInitWarnings( __wiregl_globals.warn_level_str,
						__wiregl_globals.gui_error );

	g->pack_buffer_size = wireGLRecommendedPackBufferSize (g->pipe_buffer_size);

	wireGLPackBufferInit( &g->buffer, wireGLAlloc( g->pack_buffer_size ),
						  g->pack_buffer_size );

	c = __glconfig_CreateDefaultConfig();

	c->vendor = strdup( "Stanford Univeristy Graphics Lab" );
	c->renderer = strdup( "WireGL" );

	c->flush = wireGLFlushBuffer;
	c->vpinch = wireGLVpinch;
	c->immediateapi = wiregl_im_api;
	c->packapi = wiregl_pack_api;
	c->updateclientpointer = __glpack_UpdateClientPointer;

#ifdef WINDOWS

	if( g->use_simd) {
		int i,j;
		for (i=0; vertexBBapi[i].name; i++) 
			for (j=0; vertexBBSIMDapi[j].name; j++) 
				if (!strcmp(vertexBBapi[i].name, vertexBBSIMDapi[j].name))
					vertexBBapi[i].func = vertexBBSIMDapi[j].func;
	}

	if( !g->vertex_compression )
	{
		c->vertexCapi = vertexCapi;
		c->vertexBBapi = vertexBBapi;
		c->compressionpreprocess = NULL;
		c->sendcompressiondata = NULL;
		c->compressionpostprocess = NULL;
	}
	else
	{
		if(g->unsafe_compression)
		{
			c->vertexBBapi = vertexCompressBBapi;
			c->vertexCapi = vertexCompressCapi;
		}
		else
		{
			c->vertexBBapi = vertexSafeCompressBBapi;
			c->vertexCapi = vertexSafeCompressCapi;
		}

		c->compressionpreprocess = __wiregl_CompressionPreprocess;
		c->sendcompressiondata = __wiregl_SendCompressionData;
		c->compressionpostprocess = __wiregl_CompressionPostprocess;
	}

#else /* !WINDOWS */
	
	c->vertexCapi = vertexCapi;
	c->vertexBBapi = vertexBBapi;
	c->compressionpreprocess = NULL;
	c->sendcompressiondata = NULL;
	c->compressionpostprocess = NULL;

#endif /* !WINDOWS */

	c->bounds_max = &__wiregl_globals.bounds_max;
	c->bounds_min = &__wiregl_globals.bounds_min;

	c->beginend_max = __wiregl_globals.beginend_max;

	c->numprojectors = g->num_servers;
	for ( i = 0; i < g->num_servers; i++ )
	{
		c->numextents[i] = g->servers[i].num_extents;

		for ( j = 0; j < g->servers[i].num_extents; j++ )
		{
			c->bounds[i][j].x1 = g->servers[i].mural_x[j];
			c->bounds[i][j].y1 = g->servers[i].mural_y[j];
			c->bounds[i][j].x2 = g->servers[i].mural_x[j] +
				g->servers[i].mural_w[j] ;
			c->bounds[i][j].y2 = g->servers[i].mural_y[j] +
				g->servers[i].mural_h[j];
		}
	}

	c->viewport.x1 = 0;
	c->viewport.y1 = 0;
	c->viewport.x2 = g->mural.width;
	c->viewport.y2 = g->mural.height;

	c->localviewport.x1 = 0;
	c->localviewport.y1 = 0;
	if ( !WireGLGetWindowSize( &c->localviewport.x2, &c->localviewport.y2 ) )
	{
		c->localviewport.x2 = g->mural.width;
		c->localviewport.y2 = g->mural.height;
	}

	c->getwindowsize = (GLconfig_GetWindowSize_func) WireGLGetWindowSize;
	c->viewport_valid = GL_FALSE;

	c->current = &__wiregl_globals.current;

	c->gui_error = g->gui_error;
	c->draw_bbox = g->draw_bbox;
	c->bucket_size = g->bucket_size;
	c->broadcast = g->broadcast;
	c->pack_only = g->pack_only;
	c->resolve_arrays = g->resolve_arrays;
	c->state_error_gui = g->state_error_gui;

	c->apply_viewtransform = !__wiregl_globals.use_ring && 
							 !__wiregl_globals.apply_viewtransform;
	c->optimize_bucket = __wiregl_globals.optimize_bucket;
	
	/* If we're a parallel app, broadcast our textures */
	c->broadcast_textures = is_parallel || g->broadcast_textures;

	__glInit( c );

	/* Create these in the order they are specified in bounds 
	 * I know this is kinda broken...  */
	for ( i = 0; i < g->num_servers; i++ ) 
	{
		g->servers[i].context = __glCreateContext( );
	}

	g->context = __glCreateVirtualContext( );

	__glconfig_FreeConfig( c );

	if ( is_parallel )
	{
		hack_is_parallel = 1;
	}
}	
