##
## 3/06/2001
## http://graphics.stanford.edu/software/wiregl
##
## Copyright 2001
## The Board of Trustees of The Leland Stanford Junior University.
## All rights reserved.
##
## Except for commercial resale, lease, license or other commercial
## transactions, permission is hereby given to use, copy, and/or
## modify this software, provided that the above copyright notice and
## this permission notice appear in all copies of this software.  No
## part of this software or any derivatives thereof may be used in
## graphics systems for resale or for use in a commercial product.
##
## This software is provided "as is" and without warranty of any kind,
## express, implied or otherwise, including without limitation, any
## warranty of merchantability or fitness for a particular purpose.
##

import sys;
import cPickle;
import string;

import wiregl_common;

parsed_file = open( "gl_header.parsed", "rb" )
gl_mapping = cPickle.load( parsed_file )

print """

/*
** 3/06/2001
** http://graphics.stanford.edu/software/wiregl
**
** Copyright 2001
** The Board of Trustees of The Leland Stanford Junior University.
** All rights reserved.
**
** Except for commercial resale, lease, license or other commercial
** transactions, permission is hereby given to use, copy, and/or
** modify this software, provided that the above copyright notice and
** this permission notice appear in all copies of this software.  No
** part of this software or any derivatives thereof may be used in
** graphics systems for resale or for use in a commercial product.
**
** This software is provided "as is" and without warranty of any kind,
** express, implied or otherwise, including without limitation, any
** warranty of merchantability or fitness for a particular purpose.
*/


#ifndef WIREGLGL_H
#define WIREGLGL_H

#ifndef WINDOWS
#define OPENGL_APIENTRY
#else
#ifndef OPENGL_APIENTRY
#define OPENGL_APIENTRY __stdcall
#endif
#endif

#include "wiregl/glcontext/glbase.h"

"""

print wiregl_common.PackFunctionMapping()

print """

#ifdef __cplusplus
extern "C" {
#endif
"""

keys = gl_mapping.keys()
keys.sort();

for func_name in keys:
	( return_type, arg_names, arg_types ) = gl_mapping[func_name]
	output =  return_type + ' OPENGL_APIENTRY ' + wiregl_common.PackFunction( func_name ) + '( '
	for index in range(0,len(arg_names)):
		output = output + arg_types[index]
		if arg_types[index][-1:] != '*' and arg_names[index] != '':
			output = output + " ";
		output = output + arg_names[index]
		if index != len(arg_names) - 1:
			output = output + ", "
	output = output + " );"
	print output

print "void OPENGL_APIENTRY " + wiregl_common.PackFunction( "BarrierCreate" ) + "( GLuint name, GLuint count );"
print "void OPENGL_APIENTRY " + wiregl_common.PackFunction( "BarrierDestroy" ) + "( GLuint name );"
print "void OPENGL_APIENTRY " + wiregl_common.PackFunction( "BarrierExec" ) + "( GLuint name );"
print "void OPENGL_APIENTRY " + wiregl_common.PackFunction( "SemaphoreCreate" ) + "( GLuint name, GLuint count );"
print "void OPENGL_APIENTRY " + wiregl_common.PackFunction( "SemaphoreDestroy" ) + "( GLuint name );"
print "void OPENGL_APIENTRY " + wiregl_common.PackFunction( "SemaphoreP" ) + "( GLuint name );"
print "void OPENGL_APIENTRY " + wiregl_common.PackFunction( "SemaphoreV" ) + "( GLuint name );"

print """
#ifdef __cplusplus
}
#endif

#endif /* WIREGLGL_H */
"""
