#ifdef WINDOWS

//
// geometry.h
// ==========
// Defines exported functions from the geometry compression module.
//

typedef struct
{
	GLfloat scale[3];
	GLfloat translate[3];
	char mantissaPrecision[3];
} CompressionDataT;

typedef struct
{
	GLfloat mult[3];
	GLfloat add[3];
	unsigned int mask[3];
	unsigned int nmask[3];
	int shiftLeft[2];
	int bytes;
	int bitsLeft;
	int compressionFailed;
} FastCompressionDataT;

extern GLfloat __wiregl_extentdata[3];
extern GLfloat __wiregl_startpoint[3];
extern CompressionDataT __wiregl_compressdata;
extern GLboolean __wiregl_compressiondatavalid;
extern FastCompressionDataT __wiregl_fastcompressdata;

extern void __wiregl_SendCompressionData( void );
extern void __wiregl_CompressionPreprocess( GLmatrix composite, GLint ishint );
extern void __wiregl_GuessCompressData( const GLfloat *x, const GLfloat *y, const GLfloat *z );
extern void __wiregl_CompressionPostprocess( GLfloat *bbox );

#endif
