/*
** 3/06/2001
** http://graphics.stanford.edu/software/wiregl
**
** Copyright 2001
** The Board of Trustees of The Leland Stanford Junior University.
** All rights reserved.
**
** Except for commercial resale, lease, license or other commercial
** transactions, permission is hereby given to use, copy, and/or
** modify this software, provided that the above copyright notice and
** this permission notice appear in all copies of this software.  No
** part of this software or any derivatives thereof may be used in
** graphics systems for resale or for use in a commercial product.
**
** This software is provided "as is" and without warranty of any kind,
** express, implied or otherwise, including without limitation, any
** warranty of merchantability or fitness for a particular purpose.
*/

#include "wiregl/include/wireGL.h"
#include "wiregl/include/wiregl_protocol.h"
#include "wiregl/include/wiregl_client.h"

static void __handleFogData( GLenum pname, const GLfloat *params )
{
	int packet_length = sizeof( int ) + sizeof( pname );
	unsigned char *data_ptr;
	switch( pname )
	{
		case GL_FOG_MODE:
		case GL_FOG_DENSITY:
		case GL_FOG_START:
		case GL_FOG_END:
		case GL_FOG_INDEX:
			packet_length += sizeof( *params );
			break;
		case GL_FOG_COLOR:
			packet_length += 4*sizeof( *params );
	}
	GET_BUFFERED_POINTER( packet_length );
	WRITE_DATA( 0, int, packet_length );
	WRITE_DATA( 4, GLenum, pname );
	WRITE_DATA( 8, GLfloat, params[0] );
	if (packet_length > 8) 
	{
		WRITE_DATA( 12, GLfloat, params[1] );
		WRITE_DATA( 16, GLfloat, params[2] );
		WRITE_DATA( 20, GLfloat, params[3] );
	}
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( Fogfv )(GLenum pname, const GLfloat *params)
{
	__handleFogData( pname, params );
	WRITE_OPCODE( WIREGL_FOGFV_OPCODE );
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( Fogiv )(GLenum pname, const GLint *params)
{
	/* floats and ints are the same size, so the packing should be the same */
	__handleFogData( pname, (const GLfloat *) params );
	WRITE_OPCODE( WIREGL_FOGIV_OPCODE );
}
