/*
** 3/06/2001
** http://graphics.stanford.edu/software/wiregl
**
** Copyright 2001
** The Board of Trustees of The Leland Stanford Junior University.
** All rights reserved.
**
** Except for commercial resale, lease, license or other commercial
** transactions, permission is hereby given to use, copy, and/or
** modify this software, provided that the above copyright notice and
** this permission notice appear in all copies of this software.  No
** part of this software or any derivatives thereof may be used in
** graphics systems for resale or for use in a commercial product.
**
** This software is provided "as is" and without warranty of any kind,
** express, implied or otherwise, including without limitation, any
** warranty of merchantability or fitness for a particular purpose.
*/

#include "wiregl/include/wireGL.h"
#include "wiregl/include/wiregl_protocol.h"
#include "wiregl/include/wiregl_client.h"

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( Flush )( void )
{
	wireGLFlushAll( __wiregl_globals.context );
}

void OPENGL_APIENTRY WIREGL_PACK_FUNCTION( Finish )( void )
{
	wireGLFlushAllWithOpcode( __wiregl_globals.context,
							  WIREGL_FINISH_OPCODE, 0, NULL );

	if ( __wiregl_globals.sync_on_finish )
	{
		wireGLSyncWithPipes( );
	}
}

void OPENGL_APIENTRY wireGLSwapBuffers( void )
{
	wireGLFlushAllWithOpcode( __wiregl_globals.context,
							  WIREGL_SWAPBUFFERS_OPCODE, 0, NULL );

	if ( __wiregl_globals.sync_on_swap )
	{
		wireGLSyncWithPipes( );
	}
}
