##
## 3/06/2001
## http://graphics.stanford.edu/software/wiregl
##
## Copyright 2001
## The Board of Trustees of The Leland Stanford Junior University.
## All rights reserved.
##
## Except for commercial resale, lease, license or other commercial
## transactions, permission is hereby given to use, copy, and/or
## modify this software, provided that the above copyright notice and
## this permission notice appear in all copies of this software.  No
## part of this software or any derivatives thereof may be used in
## graphics systems for resale or for use in a commercial product.
##
## This software is provided "as is" and without warranty of any kind,
## express, implied or otherwise, including without limitation, any
## warranty of merchantability or fitness for a particular purpose.
##

import sys;
import cPickle;
import string;

import wiregl_common

parsed_file = open( "gl_header.parsed", "rb" )
gl_mapping = cPickle.load( parsed_file )

print "DESCRIPTION \"\""
print "EXPORTS"

keys = gl_mapping.keys()
keys.sort();
for func_name in keys:
    print "gl" + func_name

for func_name in ( "wglChoosePixelFormat", 
		   "wglCopyContext",
		   "wglCreateContext",
		   "wglCreateLayerContext",
		   "wglDeleteContext",
		   "wglDescribeLayerPlane",
		   "wglDescribePixelFormat",
		   "wglGetCurrentContext",
		   "wglGetCurrentDC",
		   "wglGetLayerPaletteEntries",
		   "wglGetPixelFormat",
		   "wglGetProcAddress",
		   "wglMakeCurrent",
		   "wglRealizeLayerPalette",
		   "wglSetLayerPaletteEntries",
		   "wglSetPixelFormat",
		   "wglShareLists",
		   "wglSwapBuffers",
		   "wglSwapLayerBuffers",
		   "wglSwapMultipleBuffers",
		   "wglUseFontBitmapsA",
		   "wglUseFontBitmapsW",
		   "wglUseFontOutlinesA",
		   "wglUseFontOutlinesW", 
		   "wglChoosePixelFormat" ):
    print func_name + " = " + func_name + "_prox";

for func_name in ( 
		   "wireGLCreateContext",
		   "wireGLMakeCurrent",
		   "wireGLSwapBuffers",
                   "wireGLGetIntegerv",
                   "wireGLSyncWithL2",
		   "wireGLUseSystemGL" ):
    print func_name;
